package cn.smarthse.rho.modules.sys.enums.certificate;

import cn.smarthse.core.framework.utils.StringUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 放射诊疗许可范围
 */
@AllArgsConstructor
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
@Deprecated
public enum RadiationScopeEnum {

    R1_0("10", 1, "X射线影像诊断", "其他X射线影像诊断"),
    R1_1("11", 1, "X射线影像诊断", "X射线CT影像诊断CR"),
    R1_2("12", 1, "X射线影像诊断", "DR影像诊断"),
    R1_3("13", 1, "X射线影像诊断", "牙科X射线影像诊断"),
    R1_4("14", 1, "X射线影像诊断", "乳腺X射线影像诊断"),
    R1_5("15", 1, "X射线影像诊断", "普通X射线机影像诊断"),

    R2_0("20", 2, "介入放射学", "其他影像设备介入放射诊疗"),
    R2_1("21", 2, "介入放射学", "DSA介入放射诊疗"),

    R3_0("30", 3, "核医学", "其他核医学诊疗项目"),
    R3_1("31", 3, "核医学", "PET影像诊断"),
    R3_2("32", 3, "核医学", "SPECT影像诊断"),
    R3_3("33", 3, "核医学", "γ相机影像诊断"),
    R3_4("34", 3, "核医学", "骨密度测量（γ射线）"),
    R3_5("35", 3, "核医学", "籽粒插植治疗"),
    R3_6("36", 3, "核医学", "放射性药物治疗"),

    R4_0("40", 4, "放射治疗", "其他放射治疗项目"),
    R4_1("41", 4, "放射治疗", "立体定向（γ刀、X刀）治疗"),
    R4_2("42", 4, "放射治疗", "医用加速器治疗"),
    R4_3("43", 4, "放射治疗", "质子等重粒子治疗"),
    R4_4("44", 4, "放射治疗", "钴-60机治疗"),
    R4_5("45", 4, "放射治疗", "后装治疗"),
    R4_6("46", 4, "放射治疗", "深部X射线机治疗"),
    R4_7("47", 4, "放射治疗", "敷贴治疗"),
    ;

    private final String code;
    private final Integer type;
    private final String typeName;
    private final String name;

    public static String getName(String code) {

        if (code == null) {
            return null;
        }
        for (RadiationScopeEnum c : RadiationScopeEnum.values()) {
            if (c.getCode().equals(code)) {
                return c.name;
            }
        }
        return null;
    }

    public static String getNamesByCodes(String codes) {

        if (StringUtils.isNotEmpty(codes)) {
            List<String> codeList = Pattern.compile(",").splitAsStream(codes).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(codeList)) {
                List<String> nameList = new ArrayList<>();
                codeList.forEach(code -> {
                    nameList.add(getName(code));
                });
                return org.apache.commons.lang3.StringUtils.join(nameList, "、");
            }
        }
        return "";
    }

    public static String getNamesByCodes(String codes, String split) {

        if (StringUtils.isNotEmpty(codes)) {
            List<String> codeList = Pattern.compile(",").splitAsStream(codes).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(codeList)) {
                List<String> nameList = new ArrayList<>();
                codeList.forEach(code -> {
                    nameList.add(getName(code));
                });
                return org.apache.commons.lang3.StringUtils.join(nameList, split);
            }
        }
        return "";
    }
}
