package cn.smarthse.rho.modules.sys.enums;

import java.util.Date;

/**
 *
 * 个人剂量监测示警状态
 *  首次预警-1；黄色预警-2；红色预警-3；启动执法-4；
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2024/4/29 8:51
 */
public enum CDoseWarningStateEnum {

    normal("正常", 0, 0, 0),
    warning1("首次预警", 1, 0, 0),
    warning2("黄色预警", 2, 0, 0),
    warning3("红色预警", 3, 0, 0),
    warning4("启动执法", 4, 0, 0),;

    private String name;
    private int value;
    /** 上限*/
    private int low;
    /** 下限*/
    private int up;

    CDoseWarningStateEnum(String name, int value, int low, int up) {
        this.name = name;
        this.value = value;
        this.low = low;
        this.up = up;
    }

    /**
     * 示警状态确定
     * @param date 业务日期
     * @return {@link CDoseWarningStateEnum}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/4/29 9:29
     */
    public static CDoseWarningStateEnum getWarningStateEnum(Date date) {
        if (date == null) {
            return warning1;
        } else if (date.getTime() < warning1.low && date.getTime() >= warning1.up) {
            return warning2;
        } else if (date.getTime() < warning2.low && date.getTime() >= warning2.up)  {
            return warning3;
        } else if (date.getTime() < warning3.low && date.getTime() >= warning3.up) {
            return warning4;
        } else {
            return warning1;
        }
    }

    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }

    public int getValue() {
        return value;
    }
    public void setValue(int value) {
        this.value = value;
    }

    public int getLow() {
        return low;
    }
    public void setLow(int low) {
        this.low = low;
    }

    public int getUp() {
        return up;
    }
    public void setUp(int up) {
        this.up = up;
    }
}
