package cn.smarthse.rho.modules.sys.entity.x;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;

import javax.persistence.Table;

@Data
@Table(name = "x_position_device_data_statistics_day")
public class XPositionDeviceDataStatisticsDay implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 自增主键
     */
    private Long id;

    /**
     * 医院ID
     */
    private Long cid;

    /**
     * 基站ID
     */
    private Long gatewayId;

    /**
     * 检测日期
     */
    private LocalDate detectionDate;

    /**
     * 异常状况 (0: 正常, 1: 异常)
     */
    private Byte status;

    /**
     * 监测时间段数量
     */
    private Integer checkNum;

    /**
     * 异常时间段数量
     */
    private Integer exceptionNum;

    /**
     * 是否上传佐证材料 (0: 未上传, 1: 已上传)
     */
    private Byte isUploadFile;

    /**
     * 佐证材料文件ID
     */
    private Long fileId;

    /**
     * 统计生成时间
     */
    private LocalDateTime createdAt;
    /**
     * 删除状态 (0: 已删除, 1: 存在)
     */
    @TableLogic
    private Byte is_valid;
}
