package cn.smarthse.rho.modules.sys.entity.x;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import javax.persistence.*;

import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;

@Data
@Table(name = "x_position_device_data_statistics")
public class XPositionDeviceDataStatistics implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 医院ID
     */
    private Long cid;

    /**
     * 基站ID
     */
    private Long gatewayId;

    /**
     * 地图编号
     */
    private String mapId;

    /**
     * 检测日期
     */
    private LocalDate detectionDate;

    /**
     * 时段编号 (1: 0:00-1:00, 2: 1:00-2:00, ..., 24: 23:00-0:00)
     */
    private Integer hourSlotNumber;

    /**
     * 统计时段开始时间
     */
    private LocalDateTime slotStartTime;

    /**
     * 统计时段结束时间
     */
    private LocalDateTime slotEndTime;

    /**
     * 时段状态 (0: 正常, 1: 异常)
     */
    private Byte status;

    /**
     * 统计生成时间
     */
    private LocalDateTime createdAt;
    /**
     * 删除状态 (0: 已删除, 1: 存在)
     */
    @TableLogic
    private Byte is_valid;

}
