package cn.smarthse.rho.modules.sys.entity.wanda;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;

/**
 * <p>
 * VIEW
 * </p>
 *
 * @author chenliang
 * @since 2024-12-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("wanda_risk_factors")
@ApiModel(value="WandaRiskFactors对象", description="VIEW")
public class WandaRiskFactors implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    private Long id;

    @ApiModelProperty(value = "危害因素类型")
    private Integer type;

    @ApiModelProperty(value = "编码")
    private String paramCode;

    @ApiModelProperty(value = "名称")
    private String nameCh;

    @ApiModelProperty(value = "备注")
    private String remarks;

    @ApiModelProperty(value = "是否重点职业病  0否，1是 ")
    private Integer isOccupationalDisease;

    @ApiModelProperty(value = "说明")
    private String statement;

    @ApiModelProperty(value = "是否有效（0-无效，1-有效）")
    private Boolean isValid;

    @ApiModelProperty(value = "创建人")
    private Long createBy;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime createDate;

    @ApiModelProperty(value = "更新人")
    private Long updateBy;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updateDate;


}
