package cn.smarthse.rho.modules.sys.entity.wanda;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Id;
import javax.persistence.Transient;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 字典数据--万达仓
 * </p>
 *
 * @author author
 * @since 2022-12-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="WandaDictValue对象", description="字典数据--万达仓")
@TableName("wanda_dict_value")
public class WandaDictValue implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    @Id
    private Long id;

    @TableField(exist = false)
    private String name;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createDate;

    @ApiModelProperty(value = "创建人id")
    private Long createBy;

    @ApiModelProperty(value = "最后修改时间")
    private LocalDateTime updateDate;

    @ApiModelProperty(value = "最后修改人id,")
    private Long updateBy;

    @ApiModelProperty(value = "是否有效(软删)")
    private Boolean isValid;

    @ApiModelProperty(value = "字典分类id(wanda_dict_type表)")
    private Long typeId;

    @ApiModelProperty(value = "字典值（同一类型下不重复）")
    private String value;

    @ApiModelProperty(value = "字典值的标签（如性别类型下的 ‘男/女’）")
    private String valueLabel;

    @ApiModelProperty(value = "排序编号")
    private Integer sortNum;

    @ApiModelProperty(value = "父级id（当前表）")
    private Long pid;

    @ApiModelProperty(value = "是否是系统默认值")
    private Boolean defaultValue;

    @ApiModelProperty(value = "状态(1:正常 2：停用)")
    private Integer status;

    @ApiModelProperty(value = "备注")
    private String remark;


}
