package cn.smarthse.rho.modules.sys.entity.sys;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 账号表
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年9月8日 上午10:56:28
 */
@EqualsAndHashCode(callSuper = true)
@Table(name = "sys_user")
public @Data class SysUser extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId
    private Long id;
    /**
     * cid
     */
    private Long cid;
    /**
     * 医院全国统一码
     */
    private String medicalNucode;
    /**
     * 账号
     */
    private String username;
    /**
     * 昵称
     */
    private String nickname;
    /**
     * 手机号
     */
    private String tel;
    /**
     * email
     */
    private String email;
    /**
     * 来源 UserResourceEnum
     */
    private Integer resource;
    /**
     * 部门
     */
    private String department;
    /**
     * 职务
     */
    private String post;
    /**
     * 密码（盐值加密后的密文）
     */
    private String password;
    /**
     * 盐值
     */
    private String salt;
    /**
     * 是否禁用
     **/
    private Integer isForbidden;
    /**
     * 账号启用禁用时间
     */
    private LocalDateTime forbiddenUpdateTime;
    /**
     * 是否是默认密码（1-是；0-不是）
     */
    private Integer isDefaultPwd;
    /**
     * 上次修改密码日期
     */
    private LocalDateTime changePwDate;
    /**
     * 是否开启定时提示修改密码（1-开启；0-关闭）
     */
    private Integer timedPasswordReset;

    @TableField(exist = false)
    private String roleIds;

}
