package cn.smarthse.rho.modules.sys.entity.sys;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Table;
import java.io.Serializable;

/**
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2021-09-08 02:51
 */
@EqualsAndHashCode(callSuper = true)
@Table(name = "sys_role")
public @Data class SysRole extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId
    @ApiModelProperty("角色id")
    private Long id;
    /**
     * 角色编码
     */
    @ApiModelProperty("角色编码")
    private String roleCode;
    /**
     * 角色中文名
     */
    @ApiModelProperty("角色中文名")
    private String roleName;
    /**
     * 是否是系统角色
     */
    @ApiModelProperty("是否是系统角色")
    private Boolean isSys;
    /**
     * 角色描述
     */
    @ApiModelProperty("角色描述")
    private String description;
}
