package cn.smarthse.rho.modules.sys.entity.sys;

import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 操作日志
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/7 16:20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@TableName("sys_log")
public class SysLog extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @ApiModelProperty("账号id")
    @TableField("user_id")
    private Long userId;

    @ApiModelProperty("操作账号(冗余)")
    @TableField("username")
    private String username;

    @ApiModelProperty("用户姓名(冗余)")
    @TableField("fullname")
    private String fullname;

    @TableField("province_id")
    private Long provinceId;

    @TableField("city_id")
    private Long cityId;

    @TableField("area_id")
    private Long areaId;

    @TableField("street_id")
    private Long streetId;

    @ApiModelProperty("行政区划")
    @TableField("detail_area_id")
    private Long detailAreaId;

    @ApiModelProperty("cid")
    private Long cid;

    @ApiModelProperty("日志标题")
    @TableField("title")
    private String title;

    @ApiModelProperty("来源（LogResourceEnum）")
    @TableField("resource")
    private Integer resource;

    @ApiModelProperty("模块（LogModuleTypeEnum）")
    @TableField("module_type")
    private Integer moduleType;
    @TableField(exist = false)
    private String moduleTypeStr;

    @ApiModelProperty("类型（LogTypeEnum）")
    @TableField("type")
    private Integer type;
    @TableField(exist = false)
    private String typeStr;

    @ApiModelProperty("请求IP地址")
    @TableField("remote_ip")
    private String remoteIp;

    @ApiModelProperty("用户代理信息")
    @TableField("user_agent")
    private String userAgent;

    @ApiModelProperty("请求URI")
    @TableField("request_uri")
    private String requestUri;

    @ApiModelProperty("操作方式、post/get/push等resetful")
    @TableField("request_method")
    private String requestMethod;

    @ApiModelProperty("操作提交的数据内容(json)或者异常信息")
    @TableField("params")
    private String params;

    public String getModuleTypeStr() {
        if (moduleType == null) return "";
        return LogModuleTypeEnum.getModuleNameByModuleType(moduleType);
    }

    public String getTypeStr() {
        if (type == null) return "";
        return LogTypeEnum.getNameByVlaue(type);
    }
}
