
package cn.smarthse.rho.modules.sys.entity.sys;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.persistence.Table;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 *
 * 附件
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/3/13 8:42
 */
@Table(name = "sys_file")
@Data
@Accessors(chain = true)
public class SysFile extends BaseEntity implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * ID
	 */
	private Long id;
	/**
	 * 企业Id
	 */
	private Long cid;
	/**
	 * OSS路径地址（相对）
	 */
	private String ossUrl;
	/**
	 * 来源以FileResourceEnum为准
	 */
	private Integer resource;
	private Long sourceId;
	/**
	 * 附件名
	 */
	private String fileName;
	/**
	 * 附件大小
	 */
	private Long fileSize;
	/**
	 * 附件扩展名（可用于图标展示）
	 */
	private String fileExt;
	/**
	 * 附件Hash
	 */
	private String fileHash;
	/**
	 * 上传IP
	 */
	private String creatorIp;
	/**
	 * 附件描述
	 */
	private String description;

	@ApiModelProperty(value="OSS路径地址(精确)")
	/**
	 * OSS完整路径地址
	 */
	@TableField(exist = false)
	private String fullOssUrl;
}
