package cn.smarthse.rho.modules.sys.entity.sys;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;


/**
 * @author <开发者>
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2024-08-16 08:47
 */
@Accessors(chain = true)
@Table(name = "sys_business_operate_log")
public @Data class SysBusinessOperateLog implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @ApiModelProperty("模块")
    private Integer module;

    @ApiModelProperty("企业id")
    private Long cid;

    @ApiModelProperty("业务id")
    private Long businessId;

    @ApiModelProperty("操作类型")
    private Integer type;

    @ApiModelProperty("操作人")
    private String operator;

    @ApiModelProperty("操作人所在单位")
    private String operatorCompanyName;

    @ApiModelProperty("操作原因")
    private String reason;

    private Date createDate;
    private Long createBy;
    private Date updateDate;
    private Long updateBy;
    private Boolean isValid;

}
