
package cn.smarthse.rho.modules.sys.entity.sys;

import cn.smarthse.core.framework.model.BaseEntity;
import java.io.Serializable;
import javax.persistence.Table;
import lombok.Data;

/**
 *
 * 行政区划
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/3/12 11:29
 */
@Table(name = "sys_area")
public @Data class SysArea extends BaseEntity implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * ID
	 */
	private Long id;
	/**
	 * 父编号
	 */
	private Long parentId;
	/**
	 * 简称
	 */
	private String shortName;
	/**
	 * 名称
	 */
	private String name;
	/**
	 * 简拼
	 */
	private String py;
	/**
	 * 全拼
	 */
	private String pyFull;
	/**
	 * 经度
	 */
	private String lng;
	/**
	 * 纬度
	 */
	private String lat;
	/**
	 * 级别(0-国家,1-省,2-市,3-区、县,4-乡、镇、街道,5-村、居委会)
	 */
	private Integer level;
	/**
	 * 热度
	 */
	private Integer orderBy;
	/**
	 * 同一级的区域排序字段(默认为id值)
	 */
	private Long sort;
	/**
	 * 省编号
	 */
	private Long provinceId;
	/**
	 * 省名称
	 */
	private String provinceName;
	/**
	 * 市编号
	 */
	private Long cityId;
	/**
	 * 市名称
	 */
	private String cityName;
	/**
	 * 区域ID
	 */
	private Long areaId;
	/**
	 * 区域名称
	 */
	private String areaName;
	/**
	 * 乡镇街道编号
	 */
	private Long streetId;
	/**
	 * 乡镇街道名称
	 */
	private String streetName;
	/**
	 * 浙江省政府官网划分的行政区划，行政区划代码是自定义的。1的表示是自定义的
	 */
	private Boolean nameCustom;
}
