package cn.smarthse.rho.modules.sys.entity.r;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


@Data
@Table(name = "r_risk_basic_source_history")
public class RRiskBasicSourceHistory extends BaseEntity implements Serializable{
	private static final long serialVersionUID = -6053517354172055238L;
	

    @TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	
	/**
	 * 企业ID
	 */
	private Long cid;
	
	/**
	 * r_risk_basic.id
	 */
	private Long riskId;

	/**
	 * r_risk_basic_source.id
	 */
	private Long sourceId;
	
	/**
	 * 机构id
	 */
	private Long thirdOrgId;
	
	/**
	 * 业务id
	 */
	private Long businessId;

	/**
	 * 细分业务id（譬如体检，subBusinessId为具体到人员的id，此时businessId存的是对应的体检id）
	 */
	private Long subBusinessId;
	
	/**
	 * 风险名称
	 */
	private String name;
	
	/**
	 * 风险来源（RiskSourceEnum）
	 */
	private Integer source;
	
	/**
	 * 风险类型 （RiskTypeEnum）
	 */
	private Integer type;
	
	/**
	 * 发现人name
	 */
	private String finderName;
	
	/**
	 * 发现时间
	 */
	private LocalDate findTime;
	
	/**
	 * 推送年份
	 */
	private Integer year;
	
	/**
	 * 第几次推送(暂时没用)
	 */
	private Integer times;

	/**
	 * 描述
	 */
	private String description;
	
	/**
	 * 附件
	 */
	private String files;
	
	/**
	 * 整改期限
	 */
	private LocalDate requireFinishTime;
	
	/**
	 * 状态（1-未化解；2-已化解；3-已中止）
	 */
	private Integer status;
	
	/**
	 * 未化解状态(0-无；11-待整改；12-待验收；13-已退回)
	 */
	private Integer unresolvedType;
	
	/**
	 * 预警状态（1-首次预警；2-黄色预警；3-红色预警；4-启动执法）
	 */
	private Integer warningStatus;

	/**
	 * 是否由数据产生的风险（0-否；1-是）
	 */
	private Integer isGenerateByData;

	/**
	 * 参照起始时间
	 */
	private LocalDate businessStartDate;

	/**
	 * 实际完成时间 （冗余）
	 */
	private LocalDate actualFinishTime;
	
	/**
	 * 验收负责人姓名（冗余）
	 */
	private String acceptanceDirectorName;
	
	/**
	 * 整改负责人姓名（冗余）
	 */
	private String reformDirectorName;
	
	/**
	 * 验收时间（冗余）
	 */
	private LocalDate acceptanceDate;

	/**
	 * 变更原因
	 */
	private String changeReason;

	/**
	 * 变更时间
	 */
	private LocalDateTime changeDate;


}
