package cn.smarthse.rho.modules.sys.entity.r;

import java.io.Serializable;
import java.time.LocalDate;
import javax.persistence.*;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;


@EqualsAndHashCode(callSuper = true)
@Data
@Table(name = "r_risk_acceptance_record")
public class RRiskAcceptanceRecord extends BaseEntity implements Serializable{
	private static final long serialVersionUID = -3723564213744869056L;
	
	/**
	 * ID
	 */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	
	/**
	 * r_risk_basic.id
	 */
	private Long riskId;

	/**
	 * r_risk_basic_source.id
	 */
	private Long sourceId;
	
	/**
	 * 企业ID
	 */
	private Long cid;
	
	/**
	 * 整改负责人姓名（冗余）
	 */
	private String reformDirectorName;
	
	/**
	 * 要求完成时间/整改期限
	 */
	private LocalDate requireFinishTime;
	
	/**
	 * 实际完成时间
	 */
	private LocalDate actualFinishTime;
	
	/**
	 * 整改相关资料/佐证材料
	 */
	private String reformFinishedFiles;
	
	/**
	 * 整改措施
	 */
	private String reformMeasure;
	
	/**
	 * 状态（0-草稿；1-待审核；2-无需整改；3-完成)
	 */
	private Integer status;
	
	/**
	 * 验收结论（1-通过；0-不通过）
	 */
	private Integer acceptanceResult;
	
	/**
	 * 验收结论说明
	 */
	private String acceptanceResultExplain;
	
	/**
	 * 验收负责人姓名（冗余）
	 */
	private String acceptanceDirectorName;
	
	/**
	 * 验收时间
	 */
	private LocalDate acceptanceDate;
	
	/**
	 * 验收相关资料
	 */
	private String acceptanceFiles;
	
	/**
	 * 诊断/体检机构id
	 */
	private Long thirdOrgId;
	
	/**
	 * 诊断/体检机构名称
	 */
	private String thirdOrgName;
	
	/**
	 * 诊断、体检时间开始
	 */
	private LocalDate dealTimeBegin;
	
	/**
	 * 处理措施
	 */
	private Integer dealMeasure;
	
	/**
	 * 诊断、体检时间结束
	 */
	private LocalDate dealTimeEnd;

}
