package cn.smarthse.rho.modules.sys.entity.g;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 关键因素画像自检承诺书表
 * 表结构：g_self_check_commitment
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("g_self_check_commitment")
public class GSelfCheckCommitment extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 医院ID
     */
    private Long cid;

    /**
     * 关键因素画像类型
     */
    private Integer type;

    /**
     * 承诺人姓名
     */
    private String name;

    /**
     * 承诺人电话
     */
    private String phone;

    /**
     * 承诺书文件ID
     */
    private Long commitmentFile;

}
