package cn.smarthse.rho.modules.sys.entity.g;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDate;

/**
 * <p>
 * 安全装置和警示标识自检表
 * </p>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("g_safety_device_self_check")
public class GSafetyDeviceSelfCheck extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 自检记录的唯一标识
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 医院ID，关联医院数据
     */
    private Long cid;

    /**
     * 自检时间
     */
    private LocalDate checkTime;

    /**
     * 佐证材料的文件ID
     */
    private Long certificateFile;

    /**
     * 建档状态（0：草稿、1:待审核、2：被退回、3：已审核）
     */
    private Integer status;
}
