package cn.smarthse.rho.modules.sys.entity.g;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 个人防护用品自检表
 * 表结构：g_equipment_self_check
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("g_equipment_self_check")
public class GEquipmentSelfCheck extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 医院ID
     */
    private Long cid;

    /**
     * 自检时间
     */
    private LocalDate checkTime;

    /**
     * 佐证材料文件ID
     */
    private Long certificateFile;

    /**
     * 审核状态
     * 0：草稿
     * 1：待审核
     * 2：被退回
     * 3：已审核
     * -1：终止
     */
    private Integer status;
}
