package cn.smarthse.rho.modules.sys.entity.f;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;


@ApiModel(value = "三同时项目详情 对象", description = "医院：三同时项目详情")
@EqualsAndHashCode(callSuper = true)
@TableName("f_project_detail")
@Data
public class FProjectDetail extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @ApiModelProperty("三同时项目id")
    private Long projectId;

    @ApiModelProperty("类型（1-设备；2-场所）")
    private Integer type;

    @ApiModelProperty("（1-进行中；2-已完成；3-合理缺项）")
    @TableField(exist = false)
    private Integer detailStatus;

    @ApiModelProperty("设备预控评，1-正常填写；2-合理缺项；（仅用于场所，type=2）")
    private Integer fillType;

    @ApiModelProperty("预评完成状态（0-未开展；1-进行中；2-已开展）")
    private Integer preStatus;

    @ApiModelProperty("预评技术服务机构id")
    private Long preTechId;

    @ApiModelProperty("预评技术服务机构名称")
    private String preTechName;

    @ApiModelProperty("预评报告编号")
    private String preReportNo;

    @ApiModelProperty("预评报告出具时间")
    private Date preReportDate;

    @ApiModelProperty("控评完成状态（0-未开展；1-进行中；2-已开展）")
    private Integer cvaStatus;

    @ApiModelProperty("控评技术服务机构id")
    private Long cvaTechId;

    @ApiModelProperty("控评技术服务机构名称")
    private String cvaTechName;

    @ApiModelProperty("控评报告编号")
    private String cvaReportNo;

    @ApiModelProperty("控评报告出具时间")
    private Date cvaReportDate;

    @ApiModelProperty("合理缺项理由原因")
    private String reason;

    @ApiModelProperty("检测报告编号（性能/场所）")
    private String checkReportNo;

    @ApiModelProperty("检测报告编号下载url（性能/场所）")
    private String checkReportUrl;

}
