package cn.smarthse.rho.modules.sys.entity.f;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;


@ApiModel(value = "三同时项目 对象", description = "医院：三同时项目")
@EqualsAndHashCode(callSuper = true)
@TableName("f_project")
@Data
public class FProject extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @ApiModelProperty("医院id")
    private Long cid;

    @ApiModelProperty("医院名称")
    private String cname;

    @ApiModelProperty("院区")
    private String cbranch;

    @ApiModelProperty("项目名称")
    private String name;

    @ApiModelProperty("项目性质（1-新建；2-扩建；3-改建；4-技术引进；5-技术改造）")
    private Integer projectType;

    @ApiModelProperty("项目类型（放射治疗）")
    private Integer raType;

    @ApiModelProperty("职业病危害类别（1-一般；2-较重；3-严重）")
    private Integer occType;

    @ApiModelProperty("项目地址")
    private String address;

    @ApiModelProperty("项目内容")
    private String content;

    @ApiModelProperty("立项时间")
    private Date beginDate;

    @ApiModelProperty("竣工时间")
    private Date finishDate;

    @ApiModelProperty("项目状态（0-草稿；1-待审核；2-已完成；3-被退回）")
    private Integer status;

    @ApiModelProperty("设备id")
    private Long deviceId;

    @ApiModelProperty("设备编号")
    @TableField(exist = false)
    private String deviceNo;

    @ApiModelProperty("设备类型")
    @TableField(exist = false)
    private Integer deviceType;

    @ApiModelProperty("场所id")
    private String roomId;

    @ApiModelProperty("场所编号")
    private String roomNo;

    @ApiModelProperty("场所名称")
    private String roomName;
}
