
package cn.smarthse.rho.modules.sys.entity.e;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;


@Data
@Table(name = "e_source_sealed")
public class ESourceSealed extends BaseEntity implements Serializable{
	private static final long serialVersionUID = 6797860194132840282L;

	@TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	
	/**
	 * 公司id
	 */
	private Long cid;
	
	/**
	 * 基础表id(e_device表id)
	 */
	private Long did;

	/**
	 * 国家编码
	 */
	private String nuclideUniqueCode;
	
	/**
	 * 出厂活度（底数，保留两位小数）
	 */
	private BigDecimal data1;
	
	/**
	 * 出厂活度（指数）
	 */
	private Integer data2;
	
	/**
	 * 活度测量日期
	 */
	private Date measurementDate;
	
	/**
	 * 出厂日期
	 */
	private Date productionDate;
	
	/**
	 * 负责人
	 */
	private String personInCharge;
	
	


}
