
package cn.smarthse.rho.modules.sys.entity.e;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


@Data
@Table(name = "e_source_non_sealed")
public class ESourceNonSealed extends BaseEntity implements Serializable{
	private static final long serialVersionUID = 1732861779118516778L;

	@TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	
	/**
	 * 公司id
	 */
	private Long cid;
	
	/**
	 * 基础表id(e_device表id)
	 */
	private Long did;
	
	/**
	 * 物理状态（1-固态；2-液态；3-气态）
	 */
	private Integer physicalState;
	
	/**
	 * 最大等效日操作量(前，保留两位小数)
	 */
	private BigDecimal data1;
	
	/**
	 * 最大等效日操作量(后)
	 */
	private Integer data2;
	
	/**
	 * 最大等效年操作量(底数，保留两位小数)
	 */
	private BigDecimal data3;
	
	/**
	 * 最大等效年操作量(指数)
	 */
	private Integer data4;

	/**
	 * 出厂活度(底数，保留两位小数)
	 */
	private BigDecimal data5;

	/**
	 * 出厂活度(指数)
	 */
	private Integer data6;
	
	/**
	 * 负责人
	 */
	private String personInCharge;
	
	


}
