
package cn.smarthse.rho.modules.sys.entity.e;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;


@Data
@Table(name = "e_device_ray")
public class EDeviceRay extends BaseEntity implements Serializable{
	private static final long serialVersionUID = 7724801396893204882L;

	@TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	
	/**
	 * 公司id
	 */
	private Long cid;
	
	/**
	 * 基础表id(e_device表id)
	 */
	private Long did;

	/**
	 * 设备移动类型(1-固定设备；2-移动设备；3-车载设备)
	 */
	private Integer mobilityType;

	/**
	 * 是否为床边机(0-否；1-是)（mobility_type为2时才有值）
	 */
	private Integer isBedside;
	
	/**
	 * 放射诊疗类别(英文逗号分隔)(EdeviceDiagnosisTypeEnum)
	 */
	private String diagnosisType;
	
	/**
	 * 型号
	 */
	private String model;
	
	/**
	 * 主要参数
	 */
	private String parameters;
	
	/**
	 * 球管个数
	 */
	private Integer bulbNum;
	
	/**
	 * 放射检查类型（EdeviceRayCheckTypeEnum）
	 */
	private Integer checkType;
	
	/**
	 * 出厂日期
	 */
	private Date productionDate;
	
	/**
	 * 安装单位
	 */
	private String installationUnit;
	
	/**
	 * 负责人
	 */
	private String personInCharge;
	
	


}
