package cn.smarthse.rho.modules.sys.entity.e;

import java.io.Serializable;
import javax.persistence.*;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

@Data
@Table(name = "e_device")
public class EDevice extends BaseEntity implements Serializable{
	private static final long serialVersionUID = 6127795806751509487L;
	
	@TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	
	/**
	 * 单位id
	 */
	private Long cid;
	
	/**
	 * 名称
	 */
	private String name;
	
	/**
	 * 编号
	 */
	private String factoryNo;
	
	/**
	 * 生产厂家
	 */
	private String factory;
	
	/**
	 * 状态（1-正常；2-暂停使用；3-退役/报废）
	 */
	private Integer status;
	
	/**
	 * 类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）
	 */
	private Integer type;
	
	/**
	 * (核素)用途
	 */
	private String useTo;
	
	/**
	 * 所在机房/场所id
	 */
	private Long locationId;
	
	/**
	 * 许可证状态(1-未许可；2-已许可)
	 */
	private Integer licenseStatus;

	/**
	 * 已许可状态类型(1-正常；2-校验即将到期；3-校验已过期) (licenseStatus=2时才会有)
	 */
	private Integer licenseStatusType;

	/**
	 * 预警状态(21-首次预警；22-黄色预警；31-红色预警；32-启动执法)
	 */
	private Integer warningStatus;
	
	/**
	 * 使用科室id
	 */
	private Long useDepartmentId;
	
	/**
	 * 设备详情id
	 */
	private Long detailId;

	/**
	 * 数据来源(1-系统新增；2-外部对接；)
	 */
	private Integer dataSource;

	/**
	 * 职卫云id
	 */
	private String zwyId;

	/**
	 * 万达仓推送状态（1-未推送；2-推送成功；3-推送失败）
	 */
	private Integer wandaPushState;

}
