package cn.smarthse.rho.modules.sys.entity.d;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;


/**
 * 性能检测详情
 *
 * @author wuxq
 * @since 2024/4/10 16:20
 */
@ApiModel(value = "性能检测记录详情 对象", description = "医院：性能检测设备详情")
@EqualsAndHashCode(callSuper = true)
@TableName("d_device_check_data")
@Data
public class DDeviceCheckData extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @ApiModelProperty("医院id")
    private Long cid;

    @ApiModelProperty("性能检测主表id")
    private Long checkId;

    @ApiModelProperty("设备id")
    private Long deviceId;

    @ApiModelProperty("设备类型")
    @TableField(exist = false)
    private Integer deviceType;

    @ApiModelProperty("所在院区名称")
    private String hospital;

    @ApiModelProperty("院区的全国唯一编码")
    private String hospitalCode;

    @ApiModelProperty("设备名称")
    private String deviceName;

    @ApiModelProperty("设备型号")
    private String typeNo;

    @ApiModelProperty("出厂编号")
    private String factoryNo;

    // @ApiModelProperty("所在院区")
    // private String companyBranch;

    @ApiModelProperty("所在场所")
    private String location;

    @ApiModelProperty("检测结果：0-不合格；1-合格；")
    private Integer checkResult;

    @ApiModelProperty("检测时间(冗余)")
    private Date checkTime;

}
