package cn.smarthse.rho.modules.sys.entity.d;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;


/**
 * 性能检测
 *
 * @author wuxq
 * @since 2024/4/10 16:20
 */
@ApiModel(value = "性能检测记录 对象", description = "医院：性能检测")
@EqualsAndHashCode(callSuper = true)
@TableName("d_device_check")
@Data
public class DDeviceCheck extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @ApiModelProperty("医院id")
    private Long cid;

    @ApiModelProperty("检测机构名称")
    private String orgName;

    @ApiModelProperty("检测机构信用代码")
    private String orgCode;

    @ApiModelProperty("所在院区名称")
    private String hospital;

    @ApiModelProperty("院区的全国唯一编码")
    private String hospitalCode;

    @ApiModelProperty("检测类型（1-状态检测；2-验收检测；3-稳定性检测；）")
    private Integer type;

    @ApiModelProperty("检测时间")
    private Date checkTime;

    @ApiModelProperty("报告编号")
    private String reportNo;

    @ApiModelProperty("报告url")
    private String reportUrl;

}
