package cn.smarthse.rho.modules.sys.entity.c;

import cn.smarthse.common.sensitive.annotation.Desensitization;
import cn.smarthse.common.sensitive.enumd.DesensitizationType;
import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.rho.modules.sys.enums.staff.StaffCertSourceEnum;
import cn.smarthse.rho.modules.sys.enums.train.TrainingCertAuditStatusEnum;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * <p>
 * 员工：放射卫生培训概要
 * </p>
 *
 * @author chenliang
 * @since 2024-06-17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("c_training_cert")
@ApiModel(value = "CTrainingCert对象", description = "员工：放射卫生培训概要")
public class CTrainingCert extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    @ApiModelProperty(value = "培训系统培训id")
    @TableField("source_training_id")
    private Long sourceTrainingId;

    @ApiModelProperty(value = "培训系统用户报名id")
    @TableField("source_enroll_id")
    private Long sourceEnrollId;

    @ApiModelProperty(value = "培训系统证书id")
    @TableField("source_cert_id")
    private Long sourceCertId;

    @ApiModelProperty(value = "培训系统人员id")
    @TableField("source_staff_id")
    private Long sourceStaffId;

    @ApiModelProperty(value = "医院id")
    @TableField("cid")
    private Long cid;

    @ApiModelProperty(value = "院区名称")
    @TableField("comp_name")
    private String compName;

    @ApiModelProperty(value = "员工id")
    @TableField("staff_id")
    private Long staffId;

    @ApiModelProperty("人员基础信息id")
    @TableField("staff_base_info_id")
    private Long staffBaseInfoId;

    @ApiModelProperty(value = "员工姓名")
    @TableField("staff_name")
    private String staffName;

    @ApiModelProperty(value = "员工姓名（现在）")
    @TableField(exist = false)
    private String staffNameNow;

    @ApiModelProperty(value = "身份证")
    @TableField("idcard")
    @Desensitization(type = DesensitizationType.ID_CARD,start = 1,end = 2)
    private String idcard;

    @ApiModelProperty(value = "机构id")
    @TableField("tech_id")
    private Long techId;

    @ApiModelProperty(value = "机构名称")
    @TableField("tech_name")
    private String techName;

    @ApiModelProperty(value = "证书类型：1-放射卫生防护管理人员培训证； 2-放射防护培训合格证")
    @TableField("cert_type")
    private Integer certType;

    @ApiModelProperty(value = "证书编号")
    @TableField("cert_no")
    private String certNo;

    @ApiModelProperty(value = "取证日期")
    @TableField("issuance_date")
    private LocalDate issuanceDate;

    @ApiModelProperty(value = "复审日期")
    @TableField("review_date")
    private LocalDate reviewDate;

    @ApiModelProperty(value = "证书有效期")
    @TableField("cert_valid_date")
    private LocalDate certValidDate;

    @ApiModelProperty(value = "培训名称")
    @TableField("training_name")
    private String trainingName;

    @ApiModelProperty(value = "培训开始时间")
    @TableField("training_begin_date")
    private LocalDate trainingBeginDate;

    @ApiModelProperty(value = "培训结束时间")
    @TableField("training_end_date")
    private LocalDate trainingEndDate;

    @ApiModelProperty(value = "培训类型：1-初训；2-复训")
    @TableField("training_type")
    private String trainingType;

    @ApiModelProperty(value = "考核结果（0不合格，1合格）")
    @TableField("result")
    private Integer result;

    @ApiModelProperty(value = "培训内容")
    @TableField("training_content")
    private String trainingContent;

    @ApiModelProperty(value = "培训学时")
    @TableField("training_hours")
    private String trainingHours;

    @ApiModelProperty(value = "来源")
    @TableField("source")
    private Integer source;
    @ApiModelProperty(value = "来源")
    @TableField(exist = false)
    private String sourceName;

    @ApiModelProperty(value = "证书附件id")
    @TableField("cert_file_id")
    private Long certFileId;

    @ApiModelProperty(value = "证书附件url")
    @TableField("cert_file_url")
    private String certFileUrl;

    @ApiModelProperty(value = "附件名称")
    @TableField("cert_file_name")
    private String certFileName;

    @ApiModelProperty(value = "审核状态")
    @TableField("audit_status")
    private Integer auditStatus;
    @ApiModelProperty(value = "审核状态")
    @TableField(exist = false)
    private String auditStatusStr;

//    @TableField(exist = false)
//    @ApiModelProperty("过期时间")
//    private LocalDate expireTime;

    @TableField(exist = false)
    @ApiModelProperty("关键因素画像审核id")
    private Long keyFactorAuditId;

    @ApiModelProperty(value = "所在医院名称")
    @TableField(exist = false)
    private String hospitalName;

    public String getSourceName() {
        return StaffCertSourceEnum.getName(this.source);
    }

    public String getAuditStatusStr() {
        return TrainingCertAuditStatusEnum.getNameByValue(this.auditStatus);
    }
}
