package cn.smarthse.rho.modules.sys.entity.c;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 员工：统计信息
 * </p>
 *
 * @author chenliang
 * @since 2024-04-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("c_statistic")
@ApiModel(value="CStatistic对象", description="员工：统计信息")
public class CStatistic extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    @ApiModelProperty(value = "单位id")
    @TableField("cid")
    private Long cid;

    @ApiModelProperty(value = "员工id")
    @TableField("staff_id")
    private Long staffId;

    @ApiModelProperty("人员基础信息id")
    @TableField("staff_base_info_id")
    private Long staffBaseInfoId;

    @ApiModelProperty(value = "预警状态：放射证书（0正常 23:无证书-红色预警 24:无证书-启动执法）")
    @TableField("cert_warning")
    private Integer certWarning;

    @ApiModelProperty(value = "预警状态：体检（0:正常 11:已体检-首次预警 12:已体检-黄色预警 13:已体检-红色预警 14:已体检-启动执法 23:未体检-红色预警 24:未体检-启动执法）")
    @TableField("health_warning")
    private Integer healthWarning;

    @ApiModelProperty(value = "预警状态：个人剂量（0:正常 11:已监测-首次预警 12:已监测-黄色预警 13:已监测-红色预警 14:已监测-启动执法 23:未监测-红色预警 24:未监测-启动执法）")
    @TableField("dose_warning")
    private Integer doseWarning;

    @ApiModelProperty(value = "预警状态：超剂量（0:未超剂量 11:超调查剂量-已调查 12:超调查剂量-未进行）")
    @TableField("big_dose_warning")
    private Integer bigDoseWarning;

    @ApiModelProperty(value = "预警状态：超剂量（0:未超剂量 11:超年度剂量-已调查 12:超年度剂量-未进行）")
    @TableField("big_year_dose_warning")
    private Integer bigYearDoseWarning;

    @ApiModelProperty(value = "预警状态：放射防护培训（0:正常 11:已培训-首次预警 12:已培训-黄色预警 13:已培训-红色预警 14:已培训-启动执法 23:未培训-红色预警 24:未培训-启动执法）")
    @TableField("training_warning")
    private Integer trainingWarning;

    @ApiModelProperty(value = "是否是职业禁忌证")
    @TableField("if_occ_contraindication")
    private Integer ifOccContraindication;

    @ApiModelProperty(value = "是否是职业病患者")
    @TableField("if_occ_disease")
    private Integer ifOccDisease;

    @ApiModelProperty(value = "是否是疑是职业病患者")
    @TableField("if_occ_disease_possible")
    private Integer ifOccDiseasePossible;



}
