package cn.smarthse.rho.modules.sys.entity.c;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 员工：基础信息
 * </p>
 *
 * @author chenliang
 * @since 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("c_staff_base_info")
//@ApiModel(value = "CStaff对象", description = "员工：基础信息")
public class CStaffBaseInfo extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    //@ApiModelProperty(value = "姓名")
    @TableField("name")
    private String name;

    //@ApiModelProperty(value = "同步时间（指的是wanda的同步时间，不是这条数据的更新时间）")
    @TableField("sync_time")
    private LocalDateTime syncTime;

    //@ApiModelProperty(value = "来源id")
    @TableField("source_id")
    private String sourceId;

    //@ApiModelProperty(value = "手机号")
    //@EncryptField(algorithm = AlgorithmType.AES)
    private String phone;

    //@ApiModelProperty(value = "身份证类型")
    @TableField("idcard_type")
    private String idcardType;

    //@ApiModelProperty(value = "身份证")
    @TableField("idcard")
    private String idcard;

    //@ApiModelProperty(value = "性别 0-女；1-男")
    @TableField("sex")
    private Integer sex;

    //@ApiModelProperty(value = "年龄")
    @TableField("age")
    private Integer age;

    //@ApiModelProperty(value = "出生日期")
    @TableField("birthday")
    private LocalDate birthday;

    //@ApiModelProperty(value = "职业照射种类及代码")
    @TableField("ra_type")
    private String raType;

    //@ApiModelProperty(value = "头像id")
    @TableField("head_id")
    private Long headId;

    //@ApiModelProperty(value = "更新时间", hidden = true)
    @TableField("edit_time")
    private LocalDateTime editTime;


    //@ApiModelProperty(value = "更新时间", hidden = true)
    @TableField("ray_staff_time")
    private LocalDate rayStaffTime;

    //@ApiModelProperty(value = "数据来源StaffSourceEnum")
    @TableField("source")
    private Integer source;

    @TableField(exist = false)
    private CStaff staff;

}
