package cn.smarthse.rho.modules.sys.entity.c;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 员工：基础信息
 * </p>
 *
 * @author chenliang
 * @since 2024-06-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("c_staff")
@ApiModel(value="CStaff对象", description="员工：基础信息")
public class CStaff extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "人员基础信息id")
    @TableField("base_id")
    private Long baseId;

    @ApiModelProperty(value = "单位id")
    @TableField("cid")
    private Long cid;

    @ApiModelProperty(value = "部门id")
    @TableField("org_id")
    private Long orgId;

    @ApiModelProperty(value = "工号")
    @TableField("work_no")
    private String workNo;

    @ApiModelProperty(value = "岗位/工种")
    @TableField("post")
    private Long post;

    @ApiModelProperty(value = "岗位状态（0离岗 1在岗）")
    @TableField("post_status")
    private Integer postStatus;

    @ApiModelProperty(value = "人员类型（0非放射工作人员 1放射工作人员）")
    @TableField("staff_type")
    private Integer staffType;

    @ApiModelProperty(value = "上岗时间")
    @TableField("post_start_time")
    private LocalDateTime postStartTime;

    @ApiModelProperty(value = "离岗时间")
    @TableField("post_departure_time")
    private LocalDateTime postDepartureTime;

    @ApiModelProperty(value = "暂时离岗时间")
    @TableField("tp_post_departure_time")
    private LocalDateTime tpPostDepartureTime;

    @ApiModelProperty(value = "预上岗时间")
    @TableField("pre_post_start_time")
    private LocalDateTime prePostStartTime;


    @ApiModelProperty(value = "是否是放射卫生防护管理人员")
    @TableField("if_ra_manager")
    private Integer ifRaManager;

    @ApiModelProperty(value = "管理人员岗位状态（0离岗 1在岗）")
    @TableField("manager_post_status")
    private Integer managerPostStatus;

    @ApiModelProperty(value = "更新时间", hidden = true)
    @TableField("edit_time")
    private LocalDateTime editTime;

    @ApiModelProperty(value = "数据来源StaffSourceEnum")
    @TableField("source")
    private Integer source;

    @ApiModelProperty(value = "唯一标准")
    @TableField("unique_reference")
    private String uniqueReference;


}
