package cn.smarthse.rho.modules.sys.entity.c;

import cn.smarthse.common.sensitive.annotation.Desensitization;
import cn.smarthse.common.sensitive.enumd.DesensitizationType;
import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 职业健康体检详情
 *
 * @author wuxq
 * @since 2024/4/10 16:20
 */
@ApiModel(value = "职业健康体检详情 对象", description = "医院：职业健康体检详情")
@EqualsAndHashCode(callSuper = true)
@TableName("c_health_check_data")
@Data
public class CHealthCheckData extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @ApiModelProperty("职卫云id")
    private String zwyId;

    @ApiModelProperty("职卫云id")
    private String previousZwyId;

    @ApiModelProperty("体检主表id")
    private Long baseId;

    @ApiModelProperty("医院id")
    private Long cid;

    @ApiModelProperty("人员基础信息id")
    private Long staffBaseInfoId;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("身份证类型")
    private String idcardType;

    @ApiModelProperty("身份证")
    @Desensitization(type = DesensitizationType.ID_CARD,start = 1,end = 2)
    private String idcard;

    @ApiModelProperty("性别 0-女；1-男")
    private Boolean sex;

    @ApiModelProperty("年龄")
    private Integer age;

    @ApiModelProperty("岗位/工种")
    private String post;

    @ApiModelProperty("其他工种名称")
    private String otherPostName;

    @ApiModelProperty("职业照射种类及代码")
    private String raType;

    @ApiModelProperty("职业健康检查类型（1-岗前；2-在岗；3-离岗；4-应急；）")
    private Integer checkType;

    @ApiModelProperty("体检类型编码")
    private String bodyCheckType;

    @ApiModelProperty("机构id")
    private Long techId;

    @ApiModelProperty("机构名称")
    private String techName;

    @ApiModelProperty("体检时间")
    private LocalDate checkDate;

    @ApiModelProperty("危害因素编码")
    private String riskFactorCode;

    @ApiModelProperty("危害因素名称")
    private String riskFactorName;

    @ApiModelProperty("体检结论")
    private String result;

    @ApiModelProperty("体检结论code")
    private String resultCode;

    @ApiModelProperty("体检建议")
    private String suggest;

    @ApiModelProperty("适任性评价")
    private String assessment;

    @ApiModelProperty("报告编号")
    private String reportNo;

    @ApiModelProperty("报告出具时间")
    private LocalDate reportDate;

    @ApiModelProperty("总工年龄")
    private String seniorityYear;

    @ApiModelProperty("总工年月")
    private String seniorityMonth;

    @TableField(exist = false)
    @ApiModelProperty(value = "过期时间", hidden = true)
    private LocalDate expireTime;

    @TableField()
    @ApiModelProperty(value = "职卫云上传wanda的时间", hidden = true)
    private LocalDateTime wandaLoadTime;

    @TableField(exist = false)
    @ApiModelProperty(value = "医院社会信用代码", hidden = true)
    private String creditCode;

    @ApiModelProperty(value = "放射诊疗机构名称统一社会信用代码 (无则传18个0)")
    private String creditCodeEmployer;

    @ApiModelProperty(value = "放射诊疗机构名称名称")
    private String employerNameEmployer;

    @ApiModelProperty(value = "放射诊疗机构名称id (职卫云)")
    private String zwyEmployerId;

    @ApiModelProperty(value = "放射诊疗机构名称id (放射卫生在线)")
    private String rhoEmployerId;

    @ApiModelProperty(value = "是否是异常数据")
    private Integer isErrorInfo;

    @ApiModelProperty(value = "万达数据是否删除")
    private Integer wandaIsDel;

}
