package cn.smarthse.rho.modules.sys.entity.c;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDate;
import java.util.Date;


/**
 * 职业健康体检
 *
 * @author wuxq
 * @since 2024/4/10 16:20
 */
@ApiModel(value = "职业健康体检 对象", description = "医院：职业健康体检")
@EqualsAndHashCode(callSuper = true)
@TableName("c_health_check")
@Data
public class CHealthCheck extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @ApiModelProperty("医院id")
    private Long cid;

    @ApiModelProperty("机构id")
    private Long techId;

    @ApiModelProperty("机构名")
    private String techName;

    @ApiModelProperty("体检类型（1-岗前；2-在岗；3-离岗；4-应急；）")
    private Integer type;

    @ApiModelProperty("体检时间")
    private LocalDate checkDate;

    @ApiModelProperty("体检人数")
    @TableField(exist = false)
    private Integer checkNum;

    @ApiModelProperty("疑似职业病人数")
    @TableField(exist = false)
    private Integer suspectedDiseaseNum;

    @ApiModelProperty("职业禁忌证人数")
    @TableField(exist = false)
    private Integer contraindicationNum;

    @ApiModelProperty("需复查人数")
    @TableField(exist = false)
    private Integer needReCheckNum;

}
