package cn.smarthse.rho.modules.sys.entity.c;

import cn.smarthse.common.sensitive.annotation.Desensitization;
import cn.smarthse.common.sensitive.enumd.DesensitizationType;
import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 个人剂量监测人员详情
 *
 * @author wuxq
 * @since 2024/4/11 16:20
 */
@ApiModel(value = "个人剂量监测人员详情 对象", description = "医院：个人剂量监测人员详情")
@EqualsAndHashCode(callSuper = true)
@TableName("c_dose_data")
@Data
public class CDoseData extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @ApiModelProperty("fsws_dose_monitor_data.id")
    private String sourceId;

    @ApiModelProperty("fsws_dose_monitor_data.check_id")
    private String sourceCheckId;

    @ApiModelProperty("fsws_dose_monitor_data.load_time")
    private LocalDateTime sourceLoadTime;

    @ApiModelProperty("fsws_dose_monitor_data.zwy_hospital_id")
    private String sourceCid;

    @ApiModelProperty("主表ID")
    private Long baseId;

    @ApiModelProperty("医院id")
    private Long cid;

    @ApiModelProperty("人员基础信息id")
    private Long staffBaseInfoId;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("身份证")
    @Desensitization(type = DesensitizationType.ID_CARD,start = 1,end = 2)
    private String idcard;

    @ApiModelProperty("性别 0-女；1-男")
    private Integer sex;

    @ApiModelProperty("年龄")
    private Integer age;

    @ApiModelProperty("部门/科室")
    private String dept;

    @ApiModelProperty("岗位/工种")
    private String post;

    @ApiModelProperty("射线类型")
    private String raType;

    @ApiModelProperty("职业照射种类及代码")
    private String exposureType;

    @ApiModelProperty("监测机构id")
    private Long techId;

    @ApiModelProperty("监测机构名称")
    private String techName;

    @ApiModelProperty("时间")
    private LocalDate checkDate;

    @ApiModelProperty("监测周期：开始")
    private LocalDate beginDate;

    @ApiModelProperty("监测周期：结束")
    private LocalDate endDate;

    @ApiModelProperty("监测结果")
    private String result;

    @ApiModelProperty("年度剂量结果")
    private String doseResult;

    @ApiModelProperty("超剂量调查报告url")
    private String bigDoseReport;

    @ApiModelProperty("超剂量调查报告名称")
    private String bigDoseReportName;

    @ApiModelProperty("是否超剂量")
    private Boolean isBigDose;

    @ApiModelProperty("是否年度超剂量")
    private Boolean isYearBigDose;

    @ApiModelProperty("超剂量调查状态")
    private String investigateStatus;

    @ApiModelProperty("超剂量调查人")
    private String investigator;

    @ApiModelProperty("处理状态：0-未处理；1-已处理")
    private Integer dealStatus;

    @TableField(exist = false)
    @ApiModelProperty(value = "过期时间", hidden = true)
    private LocalDate expireTime;

    @TableField(exist = false)
    @ApiModelProperty(value = "报告编号", hidden = true)
    private String reportNo;

}
