package cn.smarthse.rho.modules.sys.entity.c;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 个人剂量监测
 *
 * @author wuxq
 * @since 2024/4/11 16:20
 */
@ApiModel(value = "个人剂量监测 对象", description = "医院：个人剂量监测")
@EqualsAndHashCode(callSuper = true)
@TableName("c_dose")
@Data
public class CDose extends BaseEntity {

    private static final long serialVersionUID = 1L;
    /**
     *
     */
    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @ApiModelProperty("fsws_dose_monitor.id")
    private String sourceId;

    @ApiModelProperty("fsws_dose_monitor.load_time")
    private LocalDateTime sourceLoadTime;

    @ApiModelProperty("fsws_dose_monitor.zwy_hospital_id")
    private String sourceCid;

    @ApiModelProperty("医院id")
    private Long cid;

    @ApiModelProperty("报告编号")
    private String reportNo;

    @ApiModelProperty("报告地址")
    private String reportUrl;

    @ApiModelProperty("报告名称")
    private String reportName;

    @ApiModelProperty("监测机构id")
    private Long orgId;

    @ApiModelProperty("监测机构名")
    private String orgName;

    @ApiModelProperty("监测机构信用代码")
    private String orgCode;

    @ApiModelProperty("监测周期/天")
    private Integer cycleDays;

    @ApiModelProperty("监测开始时间")
    private LocalDate beginDate;

    @ApiModelProperty("监测结束时间")
    private LocalDate endDate;

    @ApiModelProperty("监测人数")
    @TableField(exist = false)
    private Integer doseNum;

    @ApiModelProperty("监测天数")
    @TableField(exist = false)
    private Integer bigDoseNum;

}
