package cn.smarthse.rho.modules.sys.entity.b;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import java.time.LocalDateTime;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 放射防护管理领导小组
 * </p>
 *
 * @author chenliang
 * @since 2024-04-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("b_ray_manage")
@ApiModel(value="BRayManage对象", description="放射防护管理领导小组")
public class BRayManage extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    @ApiModelProperty(value = "单位id")
    @TableField("cid")
    private Long cid;

    @ApiModelProperty(value = "领导机构名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "放射卫生防护管理人员id")
    @TableField("staff_id")
    private Long staffId;

    @ApiModelProperty(value = "放射卫生防护管理人员")
    @TableField("staff_name")
    private String staffName;

    @ApiModelProperty(value = "负责人联系电话")
    @TableField("tel")
    private String tel;

    @ApiModelProperty(value = "成立文件")
    @TableField("file")
    private String file;

    @ApiModelProperty(value = "日程管理部门ids")
    @TableField("org_ids")
    private String orgIds;

    @ApiModelProperty(value = "日程管理部门名称")
    private String orgNames;

    @ApiModelProperty(value = "编辑时间")
    @TableField("edit_time")
    private LocalDateTime editTime;



}
