package cn.smarthse.rho.modules.sys.entity.b;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import java.time.LocalDateTime;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 医院：组织架构
 * </p>
 *
 * @author chenliang
 * @since 2024-04-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("b_org")
@ApiModel(value="BOrg对象", description="医院：组织架构")
public class BOrg extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    @ApiModelProperty(value = "单位id")
    @TableField("cid")
    private Long cid;

    @ApiModelProperty(value = "pid（第一级为0）")
    @TableField("pid")
    private Long pid;

    @ApiModelProperty(value = "组织机构名")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "级联部门id（eg：四级部门,则为：id1,id2,id3,id4）")
    @TableField("cascade_id")
    private String cascadeId;

    @ApiModelProperty(value = "级联部门name（eg：四级部门,则为：name1,name2,name3,name4）")
    @TableField("cascade_name")
    private String cascadeName;

    @ApiModelProperty("编辑时间")
    private LocalDateTime editTime;


}
