package cn.smarthse.rho.modules.sys.entity.b;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;

import java.time.LocalDate;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 许可校验表
 * </p>
 *
 * @author author
 * @since 2025-05-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("b_cycle_license")
public class BCycleLicense extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 公司id
     */
    private Long cid;

    /**
     * 标题
     */
    private String title;

    /**
     * 设备id
     */
    private Long deviceId;

    /**
     * 设备类型EdeviceTypeEnum
     */
    private Integer deviceType;

    /**
     * 设备名称
     */
    private String deviceName;

    /**
     * 设备编号
     */
    private String deviceNo;

    /**
     * 场所id
     */
    private Long placeId;

    /**
     * 场所名称
     */
    private String placeName;

    /**
     * 过期时间，生成风险时推断的（不是许可证上面的）
     */
    private LocalDate deductionExpiredDate;

    /**
     * 许可证上一次校验日期
     */
    private LocalDate certLastVerificationDate;

    /**
     * 许可证发证日期
     */
    private LocalDate certBeginDate;

    /**
     * 失效日期
     */
    private LocalDate certEndDate;

    /**
     * 许可证id
     */
    private Long certId;
    /**
     * 许可证源id（一般是万达id）
     */
    private String certSourceId;

    /**
     * 许可证来源
     */
    private Integer certSource;

    /**
     * 监管许可状态（0未许可 1已许可）
     */
    private Integer adminLicenseStatus;

    /**
     * 监管确认时间
     */
    private LocalDateTime adminLicenseTime;

    /**
     * 监管的id
     */
    private Long adminLicenseId;

    /**
     * 年份
     */
    private Integer year;

    /**
     * 许可记录生成时间
     */
    private LocalDateTime genTime;

    /**
     * 数据状态(0不可见 1可见)
     */
    private Integer dataState;


}
