package cn.smarthse.rho.modules.sys.entity.b;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 医院：基础信息
 * </p>
 *
 * @author chenliang
 * @since 2024-03-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("b_company")
@ApiModel(value = "BCompany对象", description = "医院：基础信息")
public class BCompany extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId
    private Long id;

    @ApiModelProperty(value = "职卫云id")
    @TableField("zwy_hospital_id")
    private String zwyHospitalId;

    @ApiModelProperty(value = "同步时间")
    @TableField("sync_time")
    private LocalDateTime syncTime;

    @ApiModelProperty(value = "入库时间")
    @TableField("entry_time")
    private LocalDateTime entryTime;

    //入库时间(年)
    @TableField("entry_year")
    private LocalDateTime entryYear;

    //入库时间（月）
    @TableField("entry_month")
    private LocalDateTime entryMonth;

    //入库时间(第某次)
    @TableField("entry_no")
    private Integer entryNo;

    @ApiModelProperty(value = "职卫云加载时间")
    @TableField("wanda_load_time")
    private LocalDateTime wandaLoadTime;

    @ApiModelProperty(value = "来源id")
    @TableField("source_id")
    private String sourceId;

    @ApiModelProperty("全国统一码")
    @TableField("medical_nucode")
    private String medicalNucode;

    @ApiModelProperty("是否是主院")
    @TableField("is_main")
    private Integer isMain;

    @ApiModelProperty("主院id")
    @TableField("main_id")
    private Long mainId;

    @ApiModelProperty("主院名称")
    @TableField("main_name")
    private String mainName;

    @ApiModelProperty("所在医院id")
    @TableField("hospital_id")
    private Long hospitalId;

    @ApiModelProperty("所在医院名称")
    @TableField("hospital_name")
    private String hospitalName;

    @ApiModelProperty(value = "医院名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "统一社会信用代码")
    @TableField("credit_code")
    private String creditCode;

    @ApiModelProperty(value = "机构类型")
    @TableField("type")
    private Integer type;

    @ApiModelProperty(value = "经济类型")
    @TableField("economy_code")
    private Integer economyCode;

    @ApiModelProperty(value = "医院等级")
    @TableField("unit_level")
    private Integer unitLevel;

    @ApiModelProperty(value = "经营性质")
    @TableField("business_type")
    private Integer businessType;

    @ApiModelProperty(value = "营业状态")
    @TableField("business_status")
    private Integer businessStatus;

    @ApiModelProperty(value = "院区状态（1-开启；0-关闭）")
    private Integer state;

    @ApiModelProperty(value = "床位数")
    @TableField("floor_num")
    private Integer floorNum;

    @ApiModelProperty(value = "工作地址行政区划")
    @TableField("area_id")
    private Long areaId;

    @ApiModelProperty(value = "工作地址详情（eg：水墩新路88号）")
    @TableField("address")
    private String address;

    @ApiModelProperty(value = "工作地址完整（eg：浙江省杭州市上城区笕桥街道水墩新路88号）")
    @TableField("full_address")
    private String fullAddress;

    @ApiModelProperty(value = "注册地址id")
    @TableField("registered_area_id")
    private Long registeredAreaId;

    @ApiModelProperty(value = "注册地址详情")
    @TableField("registered_address")
    private String registeredAddress;

    @ApiModelProperty(value = "注册地址完整")
    @TableField("registered_full_address")
    private String registeredFullAddress;


    @ApiModelProperty(value = "法人代表姓名")
    @TableField("legal_name")
    private String legalName;

    @ApiModelProperty(value = "法人代表联系电话")
    @TableField("legal_tel")
    private String legalTel;

    @ApiModelProperty(value = "主要负责人")
    @TableField("main_leader_name")
    private String mainLeaderName;

    @ApiModelProperty(value = "主要负责人手机号")
    @TableField("main_leader_tel")
    private String mainLeaderTel;

    @ApiModelProperty(value = "直属类型：0非直属， 1省直属，2市属")
    @TableField("belong_type")
    private Integer belongType;

    @ApiModelProperty(value = "监督单位")
    @TableField("supervision_unit")
    private Long supervisionUnit;

    @ApiModelProperty(value = "监督单位区域")
    @TableField("supervision_area_id")
    private Long supervisionAreaId;

    @ApiModelProperty("是否是测试")
    @TableField("is_test")
    private Integer isTest;

    @ApiModelProperty(value = "CmSourceEnum")
    @TableField("source")
    private Integer source;



    @ApiModelProperty(value = "是否需要创建账号")
    @TableField(exist = false)
    private Integer needAddAccount;

}
