package cn.smarthse.rho.modules.sys.entity.b;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 许可校验表
 * </p>
 *
 * @author chenliang
 * @since 2024-08-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("b_change_license")
@ApiModel(value="BChangeLicense对象", description="许可校验表")
public class BChangeLicense extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    //公司id
    private Long cid;

    //类型（LicenseChangeTypeEnum）
    private String type;

    //类型（LicenseChangeTypeEnum）
    private String subType;

    //标题
    private String title;

    //公司id 或者 设备id
    private Long targetId;

    //变更前值
    private String beforeValue;

    //变更后值
    private String afterValue;

    //监管许可状态（0未许可 1已许可）
    private Integer adminLicenseStatus;

    //监管确认时间
    private LocalDateTime adminLicenseTime;

    //监管id
    private Long adminLicenseId;

    //许可生成试卷
    private LocalDateTime genTime;

    //是否需要许可
    private Integer needLicense;


}
