package cn.smarthse.rho.modules.sys.entity.b;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 医院：放射诊疗许可证
 * </p>
 *
 * @author chenliang
 * @since 2024-03-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("b_cert")
@ApiModel(value="BCert对象", description="医院：放射诊疗许可证")
public class BCert extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;


    private Long id;

    @ApiModelProperty(value = "同步时间（指的是wanda的同步时间，不是这条数据的更新时间）")
    @TableField("sync_time")
    private LocalDateTime syncTime;

    @ApiModelProperty("源数据id")
    @TableField("source_id")
    private String sourceId;

    @ApiModelProperty("全国统一码")
    @TableField("medical_nucode")
    private String medicalNucode;

    @TableField("cid")
    private Long cid;

    @ApiModelProperty(value = "证书名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "许可编号")
    @TableField("cert_no")
    private String certNo;

    @ApiModelProperty(value = "发证日期")
    @TableField("begin_date")
    private LocalDateTime beginDate;

    @ApiModelProperty(value = "失效日期")
    @TableField("end_date")
    private LocalDateTime endDate;

    @ApiModelProperty(value = "最近一次校验日期")
    @TableField("last_verification_date")
    private LocalDateTime lastVerificationDate;

    @ApiModelProperty(value = "下一次校验日期")
    @TableField("next_verification_date")
    private LocalDateTime nextVerificationDate;

    @ApiModelProperty(value = "放射诊疗类别")
    @TableField("r")
    private String r;

    @ApiModelProperty(value = "来源(1wanda)")
    @TableField("source")
    private Integer source;



}
