package cn.smarthse.rho.modules.sys.entity.a;

import cn.smarthse.core.framework.model.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Table;
import java.util.Date;

/**
 * 统计：账号活跃度
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/5/14 16:34
 */
@EqualsAndHashCode(callSuper = true)
@Table(name = "a_statistic_login")
public @Data class AStatisticLogin extends BaseEntity {

    private static final long serialVersionUID = 1L;
    /**
     * cid
     */
    @ApiModelProperty("cid")
    private Long id;
    /**
     * 医院名称(总院)
     */
    @ApiModelProperty("医院名称(总院)")
    private String hospitalName;
    /**
     * 医院名称(分院)
     */
    @ApiModelProperty("医院名称(分院)")
    private String branchName;
    /**
     * 统一社会信用代码
     */
    @ApiModelProperty("统一社会信用代码")
    private String creditCode;
    /**
     * 登录次数
     */
    @ApiModelProperty("登录次数")
    private Integer loginTimes;
    /**
     * 最后一次登录时间
     */
    @ApiModelProperty("最后一次登录时间")
    private Date lastLoginTime;
}
