package cn.smarthse.rho.modules.sys.converter;

import cn.smarthse.rho.modules.sys.entity.e.EMachineRoom;
import cn.smarthse.rho.modules.sys.model.third.param.ThirdMachineRoomDto;
import cn.smarthse.rho.modules.sys.model.wanda.sync.vo.WandaZwyPlaceVo;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

/**
 * 机房
 */
@Mapper(componentModel = "spring")
public interface MachineRoomCommonConverter {
    MachineRoomCommonConverter INSTANCE = Mappers.getMapper(MachineRoomCommonConverter.class);


    /**
     * dto转基础实体
     */
    EMachineRoom thirdDto2Entity(ThirdMachineRoomDto dto);

    ThirdMachineRoomDto entity2ThirdDto(EMachineRoom dto);

    /**
     * 万达仓数据转基础实体
     */
    @Mappings({
            @Mapping(source = "rhoEngineRoomId",  target = "id"),
            @Mapping(source = "rhoHospitalId",    target = "cid")
    })
    EMachineRoom wandaVo2Entity(WandaZwyPlaceVo vo);

}