package cn.smarthse.rho.modules.sys.converter;

import cn.smarthse.rho.modules.sys.entity.e.*;
import cn.smarthse.rho.modules.sys.model.third.param.*;
import cn.smarthse.rho.modules.sys.model.wanda.sync.vo.WandaZwyDeviceVo;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

/**
 * 设备Converter
 */
@Mapper(componentModel = "spring")
public interface DeviceCommonConverter {
    DeviceCommonConverter INSTANCE = Mappers.getMapper(DeviceCommonConverter.class);

    /**
     * third - dto转基础实体
     */
    EDevice thirdBaseDto2Entity(ThirdDeviceBaseDto dto);

    /**
     * third - 射线装置 - dto转实体
     */
    @Mapping(target = "isBedside" , source = "isBedside")
    EDeviceRay thirdRayDto2Entity(ThirdDeviceRayDto dto);

    /**
     * third - 非密封放射源 - dto转实体
     */
    ESourceNonSealed thirdSourceNonDto2Entity(ThirdSourceNonSealedDto dto);

    /**
     * third - 密封放射源 - dto转实体
     */
    ESourceSealed thirdSourceSealedDto2Entity(ThirdSourceSealedDto dto);

    /**
     * third - 含密封源装置 - dto转实体
     */
    EDeviceSource thirdDeviceSourceDto2Entity(ThirdDeviceSourceDto dto);


    /**
     * wanda - vo转基础实体
     */
    EDevice wandaVo2BaseEntity(WandaZwyDeviceVo vo);

    /**
     * wanda - 射线装置 - vo转实体
     */
    @Mapping(target = "productionDate", dateFormat = "yyyy-MM-dd HH:mm:ss")
    EDeviceRay wandaVo2RayEntity(WandaZwyDeviceVo vo);

    /**
     * wanda - 非密封放射源 - vo转实体
     */
    ESourceNonSealed wandaVo2SourceNonEntity(WandaZwyDeviceVo vo);

    /**
     * wanda - 密封放射源 - vo转实体
     */
    ESourceSealed wandaVo2SourceSealedEntity(WandaZwyDeviceVo vo);

    /**
     * wanda - 含密封源装置 - vo转实体
     */
    EDeviceSource wandaVo2DeviceSourceEntity(WandaZwyDeviceVo vo);
}