/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.web.impl;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.model.ResponseStateEnum;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.modules.sys.converter.web.ArticleConverter;
import cn.smarthse.radiationTraining.modules.sys.dao.web.ArticleMapper;
import cn.smarthse.radiationTraining.modules.sys.entity.web.Article;
import cn.smarthse.radiationTraining.modules.sys.enums.web.ArticleStateEnum;
import cn.smarthse.radiationTraining.modules.sys.enums.web.ArticleTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.param.web.article.QueryArticleParam;
import cn.smarthse.radiationTraining.modules.sys.param.web.article.SaveArticleIsTopParam;
import cn.smarthse.radiationTraining.modules.sys.param.web.article.SaveArticleParam;
import cn.smarthse.radiationTraining.modules.sys.param.web.article.SaveArticleUpOrDownParam;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysFileService;
import cn.smarthse.radiationTraining.modules.sys.service.web.IArticleService;
import cn.smarthse.radiationTraining.modules.sys.vo.web.vo.ArticleApiVo;
import cn.smarthse.radiationTraining.modules.sys.vo.web.vo.ArticleListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.web.vo.ArticleTurnPage;
import cn.smarthse.radiationTraining.modules.sys.vo.web.vo.ArticleVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.annotation.Method;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@DubboService(methods={@Method(name="getArticleList"), @Method(name="getTopArticleList"), @Method(name="getHomeArticleList"), @Method(name="getHomeArticleList2"), @Method(name="getArticle"), @Method(name="getArticleApi"), @Method(name="saveArticle"), @Method(name="saveIsTop"), @Method(name="saveUpOrDown"), @Method(name="del")})
public class ArticleServiceImpl
extends ServiceImpl<ArticleMapper, Article>
implements IArticleService {
    private final ArticleConverter articleConverter;
    private final ISysFileService sysFileService;
    private final OssClientBean ossClientBean;
    private final RedisTemplate<String, Long> redisTemplate;

    @Cacheable(cacheNames={"ARTICLE:LIST"}, key="#param.type", condition="#param.queryBy==1")
    public LayuiGridData<ArticleListVo> getArticleList(QueryArticleParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        return new LayuiGridData((Page)((ArticleMapper)this.baseMapper).getArticleList(param), (LayuiGridParam)param);
    }

    @Cacheable(cacheNames={"ARTICLE:HOME"}, key="1")
    public List<ArticleListVo> getHomeArticleList() {
        List<ArticleListVo> list = ((ArticleMapper)this.baseMapper).getHomeArticleList();
        if (list != null) {
            list.forEach(record -> record.setImageUrl(this.ossClientBean.getUrl(record.getImageUrl())));
        }
        return list;
    }

    @Cacheable(cacheNames={"ARTICLE:HOMETWO"}, key="1")
    public Map<String, List<ArticleListVo>> getHomeArticleList2() {
        List<ArticleListVo> list1 = ((ArticleMapper)this.baseMapper).getHomeArticleList2(ArticleTypeEnum.type_0101.getValue());
        List<ArticleListVo> list2 = ((ArticleMapper)this.baseMapper).getHomeArticleList2(ArticleTypeEnum.type_0102.getValue());
        List<ArticleListVo> list3 = ((ArticleMapper)this.baseMapper).getHomeArticleList2(ArticleTypeEnum.type_0103.getValue());
        HashMap<String, List<ArticleListVo>> map = new HashMap<String, List<ArticleListVo>>(3);
        map.put(ArticleTypeEnum.type_0101.getValue(), list1);
        map.put(ArticleTypeEnum.type_0102.getValue(), list2);
        map.put(ArticleTypeEnum.type_0103.getValue(), list3);
        return map;
    }

    public List<ArticleListVo> getTopArticleList() {
        return ((ArticleMapper)this.baseMapper).getTopArticleList();
    }

    public ArticleVo getArticle(Long id) {
        Article article = (Article)this.getById(id);
        ArticleVo articleVo = this.articleConverter.article2ArticleVo(article);
        if (article != null) {
            articleVo.setImageUrl(this.ossClientBean.getUrl(articleVo.getImageUrl()));
            articleVo.setFiles(this.sysFileService.getFileVoByIds(article.getFiles()));
        }
        return articleVo;
    }

    @Cacheable(cacheNames={"ARTICLE:DETAIL"}, key="#id")
    public ArticleApiVo getArticleApi(Long id) {
        Article article = (Article)this.getById(id);
        if (article == null) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u8be5\u8d44\u8baf\u5df2\u88ab\u5220\u9664\uff01");
        }
        if (!ArticleStateEnum.UP.getValue().equals(article.getState())) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u8be5\u8d44\u8baf\u5df2\u4e0b\u67b6\uff01");
        }
        ArticleApiVo articleVo = this.articleConverter.article2ArticleApiVo(article);
        articleVo.setFiles(this.sysFileService.getFileVoByIds(article.getFiles()));
        articleVo.setLast(this.getLast(id, article.getType()));
        articleVo.setNext(this.getNext(id, article.getType()));
        this.redisTemplate.boundZSetOps((Object)RedisKey.ARTICLE_CLICK_KEY).incrementScore((Object)id, 1.0);
        return articleVo;
    }

    @Transactional
    public void saveArticle(SaveArticleParam param) {
        if (param == null) {
            throw new ServiceException("\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        Article article = this.articleConverter.saveArticleParam2Article(param);
        if (ArticleStateEnum.UP.getValue().equals(param.getState())) {
            article.setReleaseBy(param.getReleaseBy());
            article.setReleaser(param.getReleaser());
            article.setReleaseDate(new Date());
        }
        if (param.getId() == null) {
            article.setUpdateBy(param.getReleaseBy());
            article.setCreateBy(param.getReleaseBy());
        } else {
            ArticleVo exists = this.getArticle(param.getId());
            if (exists == null) {
                throw new ServiceException("\u8be5\u8d44\u8baf\u4e0d\u5b58\u5728\uff01");
            }
            if (ArticleStateEnum.UP.getValue().equals(exists.getState())) {
                throw new ServiceException("\u8be5\u8d44\u8baf\u5df2\u4e0a\u67b6\uff0c\u4e0d\u80fd\u4fee\u6539\uff01");
            }
            article.setUpdateBy(param.getReleaseBy());
        }
        this.saveOrUpdate(article);
    }

    @Transactional
    public void saveIsTop(SaveArticleIsTopParam param) {
        if (param == null) {
            throw new ServiceException("\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        Article article = (Article)this.getById(param.getId());
        if (article == null) {
            throw new ServiceException("\u67e5\u65e0\u8be5\u6587\u7ae0\u4fe1\u606f\uff01");
        }
        if (!article.getState().equals(ArticleStateEnum.UP.getValue())) {
            throw new ServiceException("\u4e0a\u67b6\u72b6\u6001\u7684\u6587\u7ae0\u624d\u80fd\u7f6e\u9876\uff01");
        }
        article.setUpdateBy(param.getLoginUserId());
        article.setIsTop(param.getIsTop());
        this.updateById(article);
    }

    @Transactional
    @CacheEvict(cacheNames={"ARTICLE:HOME", "ARTICLE:HOMETWO", "ARTICLE:DETAIL", "ARTICLE:LIST"}, allEntries=true)
    public void saveUpOrDown(SaveArticleUpOrDownParam param) {
        if (param == null || param.getIdList() == null) {
            throw new ServiceException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\uff01");
        }
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"idList", "state"});
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.in(Article::getId, (Collection)param.getIdList());
        Article record = new Article();
        record.setState(param.getState());
        if (ArticleStateEnum.UP.getValue().equals(param.getState())) {
            record.setReleaseBy(param.getReleaseBy());
            record.setReleaser(param.getReleaser());
            record.setReleaseDate(new Date());
        }
        record.setUpdateBy(param.getReleaseBy());
        this.update(record, (Wrapper)updateWrapper);
    }

    @Transactional
    public void del(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            throw new ServiceException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u5220\u9664\uff01");
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.in(Article::getId, idList)).in(Article::getState, new Object[]{ArticleStateEnum.DRAFT.getValue(), ArticleStateEnum.DOWN.getValue()})).eq(Article::getIsValid, (Object)Constant.YES);
        this.remove((Wrapper)wrapper);
    }

    public void updateClick(Long id, int increaseClick) {
        ((ArticleMapper)this.baseMapper).updateClick(id, increaseClick);
    }

    private ArticleTurnPage getLast(Long id, String articleType) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Article::getIsValid, (Object)Constant.TRUE)).eq(Article::getState, (Object)ArticleStateEnum.UP.getValue())).eq(Article::getType, (Object)articleType)).gt(Article::getId, (Object)id)).orderByAsc(Article::getId)).last("limit 1");
        return this.articleConverter.article2ArticleTurnPage((Article)this.getOne((Wrapper)queryWrapper));
    }

    private ArticleTurnPage getNext(Long id, String articleType) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Article::getIsValid, (Object)Constant.TRUE)).eq(Article::getState, (Object)ArticleStateEnum.UP.getValue())).eq(Article::getType, (Object)articleType)).lt(Article::getId, (Object)id)).orderByDesc(Article::getId)).last("limit 1");
        return this.articleConverter.article2ArticleTurnPage((Article)this.getOne((Wrapper)queryWrapper));
    }

    @Generated
    public ArticleServiceImpl(ArticleConverter articleConverter, ISysFileService sysFileService, OssClientBean ossClientBean, RedisTemplate<String, Long> redisTemplate) {
        this.articleConverter = articleConverter;
        this.sysFileService = sysFileService;
        this.ossClientBean = ossClientBean;
        this.redisTemplate = redisTemplate;
    }
}

