/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.user.info.impl;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.converter.user.CompanyConverter;
import cn.smarthse.radiationTraining.modules.sys.dao.user.info.SysCompanyMapper;
import cn.smarthse.radiationTraining.modules.sys.dto.user.info.ImportCompanyData;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysCompany;
import cn.smarthse.radiationTraining.modules.sys.param.sys.SearchCompanyPageParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.EditCropParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.SaveUserCropParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.info.QueryCompanyParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.info.SaveCompanyParam;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysAreaService;
import cn.smarthse.radiationTraining.modules.sys.service.user.ISysUserService;
import cn.smarthse.radiationTraining.modules.sys.service.user.info.ISysCompanyService;
import cn.smarthse.radiationTraining.modules.sys.service.user.info.ISysCompanyStaffService;
import cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyExportListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.RhoCompanyListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.SearchCompanyVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SysCompanyServiceImpl
extends ServiceImpl<SysCompanyMapper, SysCompany>
implements ISysCompanyService {
    private final CompanyConverter companyConverter;
    @Autowired
    private ISysAreaService sysAreaService;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysCompanyStaffService companyStaffService;
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Override
    public LayuiGridData<CompanyListVo> getCompanyList(QueryCompanyParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        return new LayuiGridData((Page)((SysCompanyMapper)this.baseMapper).getCompanyList(param), (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<RhoCompanyListVo> getCompanyListForRho(QueryCompanyParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        return new LayuiGridData((Page)((SysCompanyMapper)this.baseMapper).getCompanyListForRho(param), (LayuiGridParam)param);
    }

    @Override
    public CompanyInfo getCompanyInfo(Long userId) {
        return this.companyConverter.company2ConpanyInfo(this.getByUserId(userId));
    }

    @Override
    public SysCompany getCompanyByUserInfoId(Long userInfoId) {
        Long cid = this.companyStaffService.getCidBySysUserInfoId(userInfoId);
        if (cid == null) {
            return null;
        }
        return (SysCompany)this.getById(cid);
    }

    @Override
    @Transactional
    public void saveCompany(SaveUserCropParam param) {
        SysCompany company = this.getByUserId(param.getUserId());
        if (company == null) {
            if (!this.checkCreditCode(param.getCreditCode(), company.getId())) {
                throw new ServiceException(String.format("\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u201c%s\u201d\u5df2\u5b58\u5728\uff01", param.getCreditCode()));
            }
            if (!this.checkCompanyName(param.getName(), company.getId())) {
                throw new ServiceException(String.format("\u5355\u4f4d\u201c%s\u201d\u5df2\u5b58\u5728\uff01", param.getName()));
            }
            company = new SysCompany();
            company.setCreateBy(param.getLoginUserId());
        } else {
            company.setUpdateBy(param.getLoginUserId());
        }
        company.setUserId(param.getUserId());
        company.setCreditCode(param.getCreditCode());
        company.setName(param.getName());
        company.setContact(param.getContact());
        company.setContactTel(param.getContactTel());
        company.setAreaId(param.getAreaId());
        this.saveOrUpdate(company);
    }

    @Override
    @Transactional
    public void saveCompany(SaveCompanyParam param) {
        if (!this.checkCreditCode(param.getCreditCode(), param.getId())) {
            throw new ServiceException(String.format("\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u201c%s\u201d\u5df2\u5b58\u5728\uff01", param.getCreditCode()));
        }
        if (!this.checkCompanyName(param.getName(), param.getId())) {
            throw new ServiceException(String.format("\u5355\u4f4d\u201c%s\u201d\u5df2\u5b58\u5728\uff01", param.getName()));
        }
        SysCompany company = (SysCompany)this.getById(param.getId());
        if (company == null) {
            company = new SysCompany();
            company.setCreateBy(param.getLoginUserId());
        } else {
            company.setUpdateBy(param.getLoginUserId());
        }
        company.setName(param.getName());
        company.setCreditCode(param.getCreditCode());
        company.setContact(param.getContact());
        company.setContactTel(param.getContactTel());
        company.setAreaId(param.getAreaId());
        company.setAreaAddress(this.sysAreaService.getAreaAddress(param.getAreaId()));
        this.saveOrUpdate(company);
    }

    @Override
    public CompanyVo getCompany(Long id) {
        SysCompany company = (SysCompany)this.getById(id);
        if (company == null) {
            throw new ServiceException("\u67e5\u65e0\u6539\u4f01\u4e1a\u5e95\u5e93\uff01");
        }
        CompanyVo companyVo = this.companyConverter.company2CompanyVo(company);
        companyVo.setArea(this.sysAreaService.getAreaById(company.getAreaId()));
        return companyVo;
    }

    @Override
    public SysCompany getCompanyByUid(Long uid) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"user_id", (Object)uid);
        return (SysCompany)this.getOne((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void importCompany(List<ImportCompanyData> list) {
        List<String> msgList = this.checkImportCompany(list);
        if (msgList.size() > 0) {
            throw new ServiceException(Integer.valueOf(1), "\u5931\u8d25\uff01", msgList);
        }
        List data = this.companyConverter.importCompanyData2Company(list);
        this.fillParam(data);
        this.saveOrUpdateBatch(data);
        List finalData = data;
        this.threadPoolTaskExecutor.execute(() -> this.initAreaId(finalData));
    }

    @Override
    public SysCompany getByCreditCode(String creditCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysCompany::getCreditCode, (Object)creditCode)).eq(BaseBean::getIsValid, (Object)Constant.YES)).last("limit 1");
        return (SysCompany)this.getOne((Wrapper)queryWrapper);
    }

    public SysCompany getByName(String name) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysCompany::getName, (Object)name)).eq(BaseBean::getIsValid, (Object)Constant.YES)).last("limit 1");
        return (SysCompany)this.getOne((Wrapper)queryWrapper);
    }

    public List<SysCompany> getByNames(List<String> nameList) {
        if (CollectionUtils.isEmpty(nameList)) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysCompany::getName, nameList)).eq(BaseBean::getIsValid, (Object)Constant.YES);
        return this.list((Wrapper)queryWrapper);
    }

    public Map<String, SysCompany> getMapByName(List<String> nameList) {
        List<SysCompany> list = this.getByNames(nameList);
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<String, SysCompany>(0);
        }
        return list.stream().collect(Collectors.toMap(SysCompany::getName, Function.identity(), (key1, key2) -> key2));
    }

    private boolean checkCreditCode(String creditCode, Long cid) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysCompany::getCreditCode, (Object)creditCode)).eq(BaseBean::getIsValid, (Object)Constant.YES)).last("limit 1");
        SysCompany company = (SysCompany)this.getOne((Wrapper)queryWrapper);
        return company == null || company.getId().equals(cid);
    }

    private boolean checkCompanyName(String name, Long cid) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysCompany::getName, (Object)name)).eq(BaseBean::getIsValid, (Object)Constant.YES)).last("limit 1");
        SysCompany company = (SysCompany)this.getOne((Wrapper)queryWrapper);
        return company == null || company.getId().equals(cid);
    }

    @Override
    public Boolean hasCreditCode(String creditCode) {
        return this.getByCreditCode(creditCode) != null;
    }

    @Override
    public List<CompanyExportListVo> getExportCompanyList(QueryCompanyParam param) {
        return ((SysCompanyMapper)this.baseMapper).getExportCompanyList(param);
    }

    @Override
    public List<SearchCompanyVo> searchCompanyByKeywordForSelect(String keyword, Integer ifIncludeSelected) {
        return ((SysCompanyMapper)this.baseMapper).searchCompanyByKeywordForSelect(keyword, ifIncludeSelected);
    }

    @Override
    public LayuiGridData<SearchCompanyVo> searchCompanyPageByKeywordAndAreaForSelect(SearchCompanyPageParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<SearchCompanyVo> searchCompanyVos = ((SysCompanyMapper)this.baseMapper).searchCompanyPageByKeywordAndAreaForSelect(param);
        for (SearchCompanyVo vo : searchCompanyVos) {
            if (vo.getArea() == null) continue;
            String areaAddress = this.sysAreaService.getAreaAddress(Long.valueOf(vo.getArea()));
            vo.setFullAddress(areaAddress);
        }
        return new LayuiGridData((Page)searchCompanyVos, (LayuiGridParam)param);
    }

    @Override
    public void turnUserIdIntoANull(Long userId) {
        ((SysCompanyMapper)this.baseMapper).turnUserIdIntoANull(userId);
    }

    @Override
    public void setUserIdById(Long id, Long userId) {
        ((SysCompanyMapper)this.baseMapper).setUserIdById(id, userId);
    }

    @Override
    public SysCompany getCompanyByName(String name) {
        QueryWrapper sysCompanyQueryWrapper = new QueryWrapper();
        sysCompanyQueryWrapper.eq((Object)"name", (Object)name);
        return (SysCompany)((SysCompanyMapper)this.baseMapper).selectOne((Wrapper)sysCompanyQueryWrapper);
    }

    @Override
    public Boolean hasCompanyName(String name) {
        return this.getCompanyByName(name) != null;
    }

    @Override
    public SysCompany getCompanyByCreditCode(String creditCode) {
        QueryWrapper sysCompanyQueryWrapper = new QueryWrapper();
        sysCompanyQueryWrapper.eq((Object)"credit_code", (Object)creditCode);
        return (SysCompany)((SysCompanyMapper)this.baseMapper).selectOne((Wrapper)sysCompanyQueryWrapper);
    }

    @Override
    public void updateCropInfo(EditCropParam param) {
        SaveUserCropParam saveUserCropParam = param.getSaveUserCropParam();
        if (StringUtils.isEmpty((CharSequence)saveUserCropParam.getCreditCode())) {
            throw new ServiceException("\u4f01\u4e1a\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)saveUserCropParam.getName())) {
            throw new ServiceException("\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.checkCreditCode(saveUserCropParam.getCreditCode(), saveUserCropParam.getId())) {
            throw new ServiceException(String.format("\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u201c%s\u201d\u5df2\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", saveUserCropParam.getCreditCode()));
        }
        if (!this.checkCompanyName(saveUserCropParam.getName(), saveUserCropParam.getId())) {
            throw new ServiceException(String.format("\u5355\u4f4d\u201c%s\u201d\u5df2\u5b58\u5728\uff01,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", saveUserCropParam.getName()));
        }
        SysCompany sysCompany = (SysCompany)this.getById(saveUserCropParam.getId());
        if (sysCompany.getUserId() == null) {
            throw new ServiceException("\u516c\u53f8\u4e3a\u7a7a");
        }
        if (!sysCompany.getUserId().equals(param.getLoginUserId())) {
            throw new ServiceException("\u65e0\u6cd5\u4fee\u6539\u4ed6\u4eba\u4fe1\u606f");
        }
        sysCompany.setContactTel(saveUserCropParam.getContactTel()).setName(saveUserCropParam.getName()).setCreditCode(saveUserCropParam.getCreditCode()).setContact(saveUserCropParam.getContact()).setContactTel(saveUserCropParam.getContactTel()).setAreaId(saveUserCropParam.getAreaId()).setAreaAddress(this.sysAreaService.getAreaById(saveUserCropParam.getAreaId()).getAreaName()).setResource(Integer.valueOf(2));
        this.updateById(sysCompany);
        if (saveUserCropParam.getEmail() != null) {
            this.sysUserService.modifyEmailByLoginUserId(saveUserCropParam.getEmail(), saveUserCropParam.getLoginUserId());
        }
    }

    @Override
    public void updateCompanyByToken(SysCompany company) {
        SysCompany cid = this.getCompanyByUid(company.getUserId());
        company.setId(cid.getId());
        this.updateById(company);
    }

    private List<String> checkImportCompany(List<ImportCompanyData> list) {
        ArrayList<String> msgList = new ArrayList<String>();
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Map<String, SysCompany> companyMap = this.getMapByName(list.stream().map(ImportCompanyData::getName).collect(Collectors.toList()));
        Iterator<ImportCompanyData> iterator = list.iterator();
        int rowIndex = 1;
        while (iterator.hasNext()) {
            ImportCompanyData next = iterator.next();
            ++rowIndex;
            if (StrUtil.isBlank((CharSequence)next.getName())) {
                msgList.add(String.format("\u7b2c%s\u884c\uff0c\u4f01\u4e1a\u540d\u79f0\u4e3a\u7a7a\uff01", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)next.getCreditCode())) {
                msgList.add(String.format("\u7b2c%s\u884c\uff0c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u7a7a\uff01", rowIndex));
            }
            if (next.getCreditCode().length() != 18) {
                msgList.add(String.format("\u7b2c%s\u884c\uff0c\u4fe1\u7528\u4ee3\u7801\u201c%s\u201d\u4e0d\u662f18\u4f4d\uff01", rowIndex, next.getCreditCode()));
            }
            SysCompany company = companyMap.get(next.getName());
            if (!companyMap.containsKey(next.getName()) || company == null || company.getCreditCode().equals(next.getCreditCode())) continue;
            msgList.add(String.format("\u7b2c%s\u884c\uff0c\u7cfb\u7edf\u4e2d\u5b58\u5728\u4f01\u4e1a\u540d\u79f0\u4e3a\u201c%s\u201d\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u201c%s\u201d\u7684\u5355\u4f4d\uff01", rowIndex, next.getName(), company.getCreditCode()));
        }
        return msgList;
    }

    private void fillParam(List<SysCompany> data) {
        data.forEach(record -> {
            SysCompany exits = this.getByCreditCode(record.getCreditCode());
            if (exits != null) {
                record.setId(exits.getId());
            }
        });
    }

    private SysCompany getByUserId(Long userId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysCompany::getUserId, (Object)userId)).eq(BaseBean::getIsValid, (Object)Constant.YES)).last("limit 1");
        return (SysCompany)this.getOne((Wrapper)queryWrapper);
    }

    private void initAreaId(List<SysCompany> list) {
        List<String> areaAddressList = list.stream().filter(record -> record.getAreaAddress() != null).map(SysCompany::getAreaAddress).distinct().collect(Collectors.toList());
        Map<String, Long> map = this.sysAreaService.getByAreaAddress(areaAddressList);
        list.forEach(record -> record.setAreaId((Long)map.get(record.getAreaAddress())));
        this.updateBatchById(list, list.size());
    }

    @Generated
    public SysCompanyServiceImpl(CompanyConverter companyConverter, ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        this.companyConverter = companyConverter;
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
    }
}

