/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.user.impl;

import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainAttendModel;
import cn.smarthse.modules.health.supervise.model.onlineTrain.TrainStaffInfoModel;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISyncTrainInfoService;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.utils.AccountUtil;
import cn.smarthse.radiationTraining.core.framework.utils.CommonsUtils;
import cn.smarthse.radiationTraining.core.framework.utils.Digests;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.dao.user.SysUserMapper;
import cn.smarthse.radiationTraining.modules.sys.dto.AreaDto;
import cn.smarthse.radiationTraining.modules.sys.dto.sys.MsgDto;
import cn.smarthse.radiationTraining.modules.sys.entity.hse.HseBackCompany;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysCompany;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysCompanyStaff;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysUserInfo;
import cn.smarthse.radiationTraining.modules.sys.enums.hse.IdcardTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.enums.sys.MsgTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.enums.user.CompanyResourceEnum;
import cn.smarthse.radiationTraining.modules.sys.enums.user.SysUserResourceEnum;
import cn.smarthse.radiationTraining.modules.sys.enums.user.SysUserTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.param.ForbiddenParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.CorpStafferRegisterParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.QueryUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.RegisterCompanyUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.RegisterUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.RegisterXhUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.SaveUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.UserTrainTimesParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.EditUserParam;
import cn.smarthse.radiationTraining.modules.sys.service.hse.IHseBackCompanyService;
import cn.smarthse.radiationTraining.modules.sys.service.hse.IHseCompanyService;
import cn.smarthse.radiationTraining.modules.sys.service.sys.IEmailService;
import cn.smarthse.radiationTraining.modules.sys.service.sys.IMsgService;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysAreaService;
import cn.smarthse.radiationTraining.modules.sys.service.user.ISysUserService;
import cn.smarthse.radiationTraining.modules.sys.service.user.info.ISysCompanyService;
import cn.smarthse.radiationTraining.modules.sys.service.user.info.ISysCompanyStaffService;
import cn.smarthse.radiationTraining.modules.sys.service.user.info.ISysUserInfoService;
import cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo;
import cn.smarthse.radiationTraining.modules.sys.shiro.UserInfo;
import cn.smarthse.radiationTraining.modules.sys.vo.hse.HseCompanyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.CidTokenMapVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserCropListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserListVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SysUserServiceImpl
extends ServiceImpl<SysUserMapper, SysUser>
implements ISysUserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysUserServiceImpl.class);
    @Autowired
    private ISysAreaService sysAreaService;
    @Autowired
    private ISysUserService userService;
    @Autowired
    private ISysUserInfoService userInfoService;
    @Autowired
    private ISysCompanyStaffService sysCompanyStaffService;
    @Autowired
    private ISysCompanyService companyService;
    @Autowired
    private IHseBackCompanyService backCompanyService;
    @Autowired
    private IHseCompanyService hseCompanyService;
    @Autowired
    private ISysCompanyStaffService companyStaffService;
    @Autowired
    private IMsgService msgService;
    @Autowired
    private IEmailService emailService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private IHseBackCompanyService hseBackCompanyService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference(registry={"public_nacos"})
    private ISyncTrainInfoService syncTrainInfoService;

    @Override
    public SysUser selectUserByPhone(String phone) {
        if (StringUtils.isEmpty((CharSequence)phone)) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUser::getPhone, (Object)phone)).last("limit 1");
        return (SysUser)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public SysUser getUserByToken(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        return ((SysUserMapper)this.baseMapper).getUserByToken(token, null);
    }

    @Override
    public SysUser getUserByToken(String token, Integer userType) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        return ((SysUserMapper)this.baseMapper).getUserByToken(token, userType);
    }

    @Override
    public SysUser getUserByUsername(String username, Integer userType) {
        if (StringUtils.isEmpty((CharSequence)username)) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUser::getUsername, (Object)username)).eq(SysUser::getUserType, (Object)userType)).eq(BaseBean::getIsValid, (Object)Constant.YES)).last("limit 1");
        return (SysUser)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public SysUser getUserByPhone(String phone) {
        if (StringUtils.isEmpty((CharSequence)phone)) {
            return null;
        }
        return ((SysUserMapper)this.baseMapper).getUserByPhone(phone);
    }

    @Override
    public SysUser getCompanyUserByToken(Long token, Integer userType) {
        if (token == null) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUser::getToken, (Object)token)).eq(SysUser::getUserType, (Object)userType)).eq(BaseBean::getIsValid, (Object)Constant.YES)).last("limit 1");
        return (SysUser)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean checkIdcard(Long userId, String idcard) {
        SysUser exists = this.getOneByIdCard(idcard);
        return exists == null || exists.getId().equals(userId);
    }

    @Override
    public void modifyPassword(Long userId, String password) {
        SysUser user = (SysUser)this.getById(userId);
        if (user == null) {
            throw new ServiceException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        String salt = Digests.salt();
        user.setPassword(CommonsUtils.encryptPassword((String)password, (String)salt));
        user.setSalt(salt);
        user.setUpdateDate(LocalDateTime.now());
        user.setIsChangePwd(Integer.valueOf(Constant.YES));
        user.setIsDefaultPwd(Boolean.valueOf(false));
        user.setPwdUpdateTime(new Date());
        this.updateById(user);
    }

    @Override
    public void modifyEmailByLoginUserId(String email, Long userId) {
        SysUser oneByEmail = this.getOneByEmail(email);
        if (oneByEmail != null && userId.equals(oneByEmail.getId())) {
            throw new ServiceException("\u90ae\u7bb1\u5df2\u88ab\u4f7f\u7528");
        }
        SysUser sysUser = (SysUser)((SysUserMapper)this.baseMapper).selectById(userId);
        sysUser.setEmail(email);
        ((SysUserMapper)this.baseMapper).updateById(sysUser);
    }

    @Override
    public SysUser getByCid(Long cid) {
        return ((SysUserMapper)this.baseMapper).getByCid(cid);
    }

    @Override
    public List<CidTokenMapVo> getListByToken(List<Long> tokenList) {
        return ((SysUserMapper)this.baseMapper).getListByToken(tokenList);
    }

    @Override
    public Set<String> getAllCompanyToken() {
        return ((SysUserMapper)this.baseMapper).getAllCompanyToken();
    }

    @Override
    public Long updateUserByToken(SysUser sysUser) {
        SysUser userId = this.getUserByToken(sysUser.getToken().toString());
        sysUser.setId(userId.getId());
        this.updateById(sysUser);
        return userId.getId();
    }

    @Override
    public List<SysUser> getByCIDList(List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            return null;
        }
        return ((SysUserMapper)this.baseMapper).getByCIDList(cidList);
    }

    @Override
    public void modifyPasswordByPhone(String phone, String newPassword) {
        SysUser user = this.getUserByPhone(phone);
        if (user == null) {
            throw new ServiceException("\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        String salt = Digests.salt();
        user.setPassword(CommonsUtils.encryptPassword((String)newPassword, (String)salt));
        user.setSalt(salt);
        user.setUpdateDate(LocalDateTime.now());
        user.setIsDefaultPwd(Boolean.valueOf(false));
        user.setPwdUpdateTime(new Date());
        this.updateById(user);
    }

    @Override
    public void modifyPasswordByEmail(String email, String newPassword) {
        SysUser user = this.getUserByEmail(email);
        if (user == null) {
            throw new ServiceException("\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        String salt = Digests.salt();
        user.setPassword(CommonsUtils.encryptPassword((String)newPassword, (String)salt));
        user.setSalt(salt);
        user.setUpdateDate(LocalDateTime.now());
        user.setIsDefaultPwd(Boolean.valueOf(false));
        user.setPwdUpdateTime(new Date());
        this.updateById(user);
    }

    @Override
    public void modifyPasswordByOldPwd(String phone, String oldPassword, String newPassword) {
        String encryptPassword;
        SysUser user = this.selectUserByPhone(phone);
        if (user == null) {
            throw new ServiceException("\u67e5\u65e0\u8be5\u624b\u673a\u53f7\uff01");
        }
        String password = user.getPassword();
        if (!password.equals(encryptPassword = CommonsUtils.encryptPassword((String)oldPassword, (String)user.getSalt()))) {
            throw new ServiceException("\u65e7\u5bc6\u7801\u9519\u8bef\uff01");
        }
        String salt = Digests.salt();
        user.setPassword(CommonsUtils.encryptPassword((String)newPassword, (String)salt));
        user.setSalt(salt);
        user.setUpdateDate(LocalDateTime.now());
        this.updateById(user);
    }

    @Override
    public void modifyPasswordByOldPwd(Long userId, String oldPassword, String newPassword) {
        String encryptPassword;
        SysUser user = (SysUser)this.getById(userId);
        if (user == null) {
            throw new ServiceException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        if ("Zyj@2022".equals(newPassword)) {
            throw new ServiceException("\u4e0d\u80fd\u4fee\u6539\u4e3a\u9ed8\u8ba4\u5bc6\u7801\uff01");
        }
        String password = user.getPassword();
        if (!password.equals(encryptPassword = CommonsUtils.encryptPassword((String)oldPassword, (String)user.getSalt()))) {
            throw new ServiceException("\u65e7\u5bc6\u7801\u9519\u8bef\uff01");
        }
        if (user.getPassword().equals(CommonsUtils.encryptPassword((String)newPassword, (String)user.getSalt()))) {
            throw new ServiceException("\u65b0\u5bc6\u7801\u4e0e\u65e7\u5bc6\u7801\u76f8\u540c\uff01");
        }
        String salt = Digests.salt();
        user.setPassword(CommonsUtils.encryptPassword((String)newPassword, (String)salt));
        user.setSalt(salt);
        user.setIsChangePwd(Integer.valueOf(Constant.YES));
        user.setUpdateDate(LocalDateTime.now());
        user.setIsDefaultPwd(Boolean.valueOf(false));
        user.setPwdUpdateTime(new Date());
        this.updateById(user);
    }

    @Override
    public LayuiGridData<UserListVo> getUserList(QueryUserParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<UserListVo> userList = ((SysUserMapper)this.baseMapper).getUserList(param);
        UserTrainTimesParam trainTimesParam = new UserTrainTimesParam(param.getIsSpecifiedUser());
        trainTimesParam.setAreaId(param.getAreaId());
        userList.stream().forEach(user -> {
            trainTimesParam.setUid(user.getId());
            user.setTrainingTimes(Integer.valueOf(((SysUserMapper)this.baseMapper).getUserTrainTimes(trainTimesParam)));
        });
        for (UserListVo vo : userList) {
            vo.setUsername(StringUtils.desensitizationUsernameNumber((String)vo.getUsername()));
            vo.setName(StringUtils.desensitizationName((String)vo.getName()));
            vo.setEmail(DesensitizedUtil.email((String)vo.getEmail()));
        }
        return new LayuiGridData((Page)userList, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    public void saveUser(SaveUserParam param) {
        if (StrUtil.isNotBlank((CharSequence)param.getUserName()) && StrUtil.contains((CharSequence)param.getUserName(), (CharSequence)"*")) {
            throw new ServiceException("\u7528\u6237\u540d\u4e0d\u80fd\u5305\u542b*\u7b26\u53f7");
        }
        SysUser user = new SysUser();
        user.setId(param.getId());
        user.setEmail(param.getEmail());
        user.setName(param.getName());
        user.setUsername(param.getUserName());
        user.setIsTest(param.getIsTest());
        if (!this.checkEmail(param.getEmail(), user.getId())) {
            throw new ServiceException(String.format("\u8be5\u90ae\u7bb1\u201c%s\u201d\u5df2\u88ab\u5176\u5b83\u8d26\u53f7\u7ed1\u5b9a\uff01", param.getEmail()));
        }
        if (!this.checkUsername(param.getUserName(), user.getId())) {
            throw new ServiceException(String.format("\u8be5\u8d26\u53f7\u540d\u201c%s\u201d\u5df2\u88ab\u5176\u5b83\u8d26\u53f7\u7ed1\u5b9a\uff01", param.getUserName()));
        }
        if (param.getId() == null) {
            String salt = Digests.salt();
            user.setPassword(CommonsUtils.encryptPassword((String)"Zyj@2022", (String)salt));
            user.setSalt(salt);
            user.setCreateBy(param.getLoginUserId());
        } else {
            user.setUpdateBy(param.getLoginUserId());
            user.setUpdateDate(LocalDateTime.now());
            if (StringUtils.isNotEmpty((String)param.getIdcard())) {
                this.userInfoService.updateByUserId(param);
            }
        }
        this.saveOrUpdate(user);
    }

    @Override
    public boolean checkEmail(String email, Long userId) {
        SysUser user = this.getUserByEmail(email);
        return user == null || user.getId().equals(userId);
    }

    public boolean checkIdCard(String idcard, Long userId) {
        SysUser user = this.getOneByIdCard(idcard);
        return user == null || user.getId().equals(userId);
    }

    @Override
    @Transactional
    public void del(List<Long> idList, Integer type, Long adminId) {
        if (CollectionUtils.isEmpty(idList)) {
            throw new ServiceException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\uff01");
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.in(SysUser::getId, idList);
        SysUser user = new SysUser();
        user.setUpdateBy(adminId);
        user.setUpdateDate(LocalDateTime.now());
        this.update(user, (Wrapper)wrapper);
        this.removeByIds(idList);
        if (SysUserResourceEnum.COMPANY_IMPORT.getValue().equals(type)) {
            idList.stream().forEach(id -> {
                CompanyInfo companyInfo = this.companyService.getCompanyInfo((Long)id);
                SysCompany sysCompany = (SysCompany)this.companyService.getById(companyInfo.getId());
                sysCompany.setUserId(null);
                this.companyService.updateById(sysCompany);
            });
        } else {
            idList.stream().forEach(id -> {
                UserInfo userInfo = this.userInfoService.getUserInfo((Long)id);
                this.userInfoService.removeById(userInfo.getId());
                this.companyStaffService.deleteBySysUserInfoId(userInfo.getId());
            });
        }
    }

    @Override
    public void resetPassword(List<Long> idList, Long adminId) {
        if (CollectionUtils.isEmpty(idList)) {
            throw new ServiceException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\uff01");
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.in(SysUser::getId, idList);
        SysUser user = new SysUser();
        String salt = Digests.salt();
        user.setPassword(CommonsUtils.encryptPassword((String)"Zyj@2022", (String)salt));
        user.setSalt(salt);
        user.setIsDefaultPwd(Constant.TRUE);
        user.setUpdateBy(adminId);
        user.setUpdateDate(LocalDateTime.now());
        this.update(user, (Wrapper)wrapper);
        this.threadPoolTaskExecutor.execute(() -> idList.stream().forEach(id -> {
            SysUser record = (SysUser)this.getById((Serializable)id);
            if (record != null && !StringUtils.isEmpty((CharSequence)record.getEmail())) {
                this.emailService.sendHtmlEmail(record.getEmail(), String.format("\u60a8\u7684\u8d26\u53f7\u201c%s\u201d\u5bc6\u7801\u5df2\u88ab\u540e\u53f0\u7ba1\u7406\u5458\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u5bc6\u7801\u201c%s\u201d\uff0c\u60a8\u53ef\u4ee5\u5728\u201c\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u57f9\u8badAPP\u201d\u4e0a\u4fee\u6539\u5bc6\u7801\uff01", record.getUsername(), "Zyj@2022"));
            }
        }));
    }

    @Override
    @Transactional
    public void forbiddenUser(ForbiddenParam param) {
        if (CollectionUtils.isEmpty((Collection)param.getIdList())) {
            throw new ServiceException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\uff01");
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.in(SysUser::getId, (Collection)param.getIdList());
        SysUser user = new SysUser();
        user.setIsForbidden(param.getIsForbidden());
        user.setUpdateBy(param.getLoginUserId());
        user.setUpdateDate(LocalDateTime.now());
        this.update(user, (Wrapper)wrapper);
    }

    @Override
    public LayuiGridData<UserCropListVo> getUserCropList(QueryUserParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        return new LayuiGridData((Page)((SysUserMapper)this.baseMapper).getUserCropList(param), (LayuiGridParam)param);
    }

    @Override
    public SysUser getUserByEmail(String email) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUser::getEmail, (Object)email)).eq(BaseBean::getIsValid, (Object)Constant.YES)).last("limit 1");
        return (SysUser)this.getOne((Wrapper)queryWrapper);
    }

    private String getPassword(String md5Password, String salt) {
        return CommonsUtils.encryptPassword((String)md5Password, (String)salt);
    }

    @Override
    @Transactional
    public Long register(String phone, String ... args) {
        SysUser db = this.selectUserByPhone(phone);
        if (ObjectUtil.isNotNull((Object)db)) {
            throw new ServiceException("\u7528\u6237\u5df2\u7ecf\u5b58\u5728\uff01");
        }
        SysUser user = new SysUser();
        user.setPhone(phone);
        String salt = IdUtil.simpleUUID();
        String encryptPassword = args.length > 0 ? CommonsUtils.encryptPassword((String)args[0], (String)salt) : CommonsUtils.encryptPassword((String)phone.substring(5, 11), (String)salt);
        user.setPassword(encryptPassword);
        user.setSalt(salt);
        this.save(user);
        return user.getId();
    }

    @Override
    @Transactional
    public SysUser personalUserRegister(RegisterUserParam userParam) {
        if (this.isExistsUserNameFromUser(userParam.getUsername())) {
            throw new ServiceException("\u8be5\u8d26\u53f7\uff08" + userParam.getUsername() + "\uff09\u5df2\u5b58\u5728\uff01");
        }
        if (this.isExistsPhone(userParam.getPhone())) {
            throw new ServiceException("\u8be5\u624b\u673a\u53f7\uff08" + userParam.getPhone() + "\uff09\u5df2\u5b58\u5728\uff01");
        }
        if (this.isExistsEmail(userParam.getEmail())) {
            throw new ServiceException("\u8be5\u90ae\u7bb1\uff08" + userParam.getEmail() + "\uff09\u5df2\u5b58\u5728\uff01");
        }
        String salt = IdUtil.simpleUUID();
        SysUser user = new SysUser().setName(userParam.getName()).setUsername(userParam.getUsername()).setPhone(userParam.getPhone()).setEmail(userParam.getEmail()).setPassword(CommonsUtils.encryptPassword((String)userParam.getPassword(), (String)salt)).setSalt(salt).setIsTest(Integer.valueOf(0)).setIsChangePwd(Integer.valueOf(Constant.YES)).setUserType(SysUserTypeEnum.USER.getValue()).setResource(SysUserResourceEnum.USER_REGISTER.getValue()).setIsDefaultPwd(Boolean.valueOf(false)).setZlbUserId(userParam.getZlbUserId()).setPwdUpdateTime(new Date());
        this.save(user);
        SysUserInfo info = new SysUserInfo().setUserId(user.getId()).setName(userParam.getName()).setIdcard(userParam.getIdcard()).setIdcardType(userParam.getIdcardType()).setSex(userParam.getSex());
        this.userInfoService.save(info);
        return user;
    }

    @Override
    @Transactional
    public SysUser personalUserRegisterForXh(RegisterXhUserParam userParam) {
        if (this.isExistsUserNameFromUser(userParam.getUsername())) {
            throw new ServiceException("\u6ce8\u518c\u5931\u8d25");
        }
        SysUser userByPhone = this.getUserByPhone(userParam.getPhone());
        if (userByPhone != null) {
            if (userByPhone.getHasRegisteredXh() == 0) {
                this.modifyPassword(userByPhone.getId(), userParam.getPassword());
                this.modifyLoginMsStatus(userByPhone.getId());
                return userByPhone;
            }
            throw new ServiceException("\u6ce8\u518c\u5931\u8d25");
        }
        String salt = IdUtil.simpleUUID();
        SysUser user = new SysUser().setUsername(userParam.getUsername()).setPhone(userParam.getPhone()).setHasRegisteredXh(Integer.valueOf(1)).setPassword(CommonsUtils.encryptPassword((String)userParam.getPassword(), (String)salt)).setSalt(salt).setIsTest(Integer.valueOf(0)).setIsChangePwd(Integer.valueOf(Constant.YES)).setUserType(SysUserTypeEnum.USER.getValue()).setResource(SysUserResourceEnum.USER_REGISTER.getValue()).setIsDefaultPwd(Boolean.valueOf(false)).setPwdUpdateTime(new Date());
        this.save(user);
        SysUserInfo info = new SysUserInfo().setUserId(user.getId());
        this.userInfoService.save(info);
        return user;
    }

    @Override
    public void createUserForImport(List<RegisterUserParam> userParamList) {
        for (RegisterUserParam userParam : userParamList) {
            SysUser oneByIdCard;
            if (this.isExistsUserNameFromUser(userParam.getUsername()) || (oneByIdCard = this.getOneByIdCard(userParam.getUsername())) != null) continue;
            String salt = IdUtil.simpleUUID();
            SysUser user = new SysUser().setName(userParam.getName()).setUsername(userParam.getUsername()).setPassword(CommonsUtils.encryptPassword((String)"Zyj@2022", (String)salt)).setSalt(salt).setIsTest(Integer.valueOf(0)).setIsChangePwd(Integer.valueOf(Constant.YES)).setUserType(SysUserTypeEnum.USER.getValue()).setResource(SysUserResourceEnum.CET_IMPORT.getValue()).setIsForbidden(Integer.valueOf(1)).setIsDefaultPwd(Boolean.valueOf(true));
            this.save(user);
            SysUserInfo info = new SysUserInfo().setUserId(user.getId()).setName(userParam.getName()).setIdcard(userParam.getUsername());
            this.userInfoService.save(info);
        }
    }

    @Override
    @Transactional
    public SysUser corpImportSingleUser(CorpStafferRegisterParam userParam) {
        if (this.isExistsEmail(userParam.getEmail())) {
            throw new ServiceException("\u8be5\u90ae\u7bb1\uff08" + userParam.getEmail() + "\uff09\u5df2\u88ab\u5176\u4ed6\u8d26\u53f7\u7ed1\u5b9a\uff01");
        }
        if (this.isExistsIdCard(userParam.getIdCard())) {
            throw new ServiceException("\u8be5\u8eab\u4efd\u8bc1\uff08" + userParam.getIdCard() + "\uff09\u5df2\u88ab\u5176\u4ed6\u8d26\u53f7\u7ed1\u5b9a\uff01");
        }
        String salt = IdUtil.simpleUUID();
        SysUser user = new SysUser().setName(userParam.getName()).setEmail(userParam.getEmail()).setUsername(StringUtils.generateUsername()).setResource(Integer.valueOf(2)).setPassword(CommonsUtils.encryptPassword((String)userParam.getPassword(), (String)salt)).setSalt(salt).setUserType(SysUserTypeEnum.USER.getValue()).setResource(SysUserResourceEnum.COMPANY_IMPORT.getValue());
        user.setResource(SysUserResourceEnum.COMPANY_IMPORT.getValue());
        user.setCreateBy(userParam.getLoginUserId());
        user.setUpdateBy(userParam.getLoginUserId());
        user.setUpdateDate(LocalDateTime.now());
        user.setCreateDate(LocalDateTime.now());
        this.save(user);
        SysUserInfo info = new SysUserInfo().setUserId(user.getId()).setName(userParam.getName()).setIdcard(userParam.getIdCard());
        info.setCreateBy(userParam.getLoginUserId());
        info.setUpdateBy(userParam.getLoginUserId());
        info.setUpdateDate(LocalDateTime.now());
        info.setCreateDate(LocalDateTime.now());
        this.userInfoService.save(info);
        this.companyStaffService.save(userParam.getCid(), info.getId(), userParam.getLoginUserId());
        return user;
    }

    @Override
    @Transactional
    public List<SysUser> corpImportSingleUserList(List<CorpStafferRegisterParam> registerUserParamList) {
        ArrayList<SysUser> sysUserList = new ArrayList<SysUser>();
        for (CorpStafferRegisterParam registerUserParam : registerUserParamList) {
            SysUser sysUser = this.corpImportSingleUser(registerUserParam);
            sysUserList.add(sysUser);
        }
        return sysUserList;
    }

    @Override
    public void companyUserRegister(RegisterCompanyUserParam companyUserParam) {
        if (this.isExistsUserName(companyUserParam.getCompanyName())) {
            throw new ServiceException("\u8be5\u8d26\u53f7\uff08" + companyUserParam.getCompanyName() + "\uff09\u5df2\u5b58\u5728\uff01");
        }
        if (this.isExistsEmail(companyUserParam.getEmail())) {
            throw new ServiceException("\u8be5\u90ae\u7bb1\uff08" + companyUserParam.getEmail() + "\uff09\u5df2\u88ab\u5176\u4ed6\u8d26\u53f7\u7ed1\u5b9a\uff01");
        }
        String salt = IdUtil.simpleUUID();
        SysUser user = new SysUser().setUsername(companyUserParam.getCompanyName()).setName(companyUserParam.getCompanyName()).setEmail(companyUserParam.getEmail()).setUserType(SysUserTypeEnum.COMPANY.getValue()).setPassword(CommonsUtils.encryptPassword((String)companyUserParam.getPassword(), (String)salt)).setSalt(salt).setIsChangePwd(Integer.valueOf(Constant.YES)).setAreaId(companyUserParam.getAreaId());
        this.save(user);
        SysCompany company = new SysCompany().setUserId(user.getId()).setName(companyUserParam.getCompanyName()).setCreditCode(companyUserParam.getCreditCode()).setAreaId(companyUserParam.getAreaId()).setAddress(companyUserParam.getAddressDetail()).setContactTel(companyUserParam.getContactNumber()).setResource(CompanyResourceEnum.COMPANY.getValue()).setAreaAddress(this.sysAreaService.getAreaAddress(companyUserParam.getAreaId()));
        if (companyUserParam.getCid() != null) {
            SysCompany sysCompanyLibrary = (SysCompany)this.companyService.getById(companyUserParam.getCid());
            if (sysCompanyLibrary != null) {
                if (sysCompanyLibrary.getUserId() != null) {
                    throw new ServiceException("\u8be5\u516c\u53f8\u5df2\u88ab\u6ce8\u518c\uff01");
                }
                sysCompanyLibrary.setUserId(user.getId());
                sysCompanyLibrary.setAreaId(companyUserParam.getAreaId());
                sysCompanyLibrary.setAddress(companyUserParam.getAddressDetail());
                sysCompanyLibrary.setAreaAddress(this.sysAreaService.getAreaAddress(companyUserParam.getAreaId()));
                sysCompanyLibrary.setContactTel(companyUserParam.getContactNumber());
                this.companyService.updateById(sysCompanyLibrary);
            } else {
                this.checkCNameAndCreditCode(company.getName(), company.getCreditCode());
                this.companyService.save(company);
            }
        } else {
            this.checkCNameAndCreditCode(company.getName(), company.getCreditCode());
            this.companyService.save(company);
        }
    }

    @Override
    @Transactional
    public SysUser companyUserRegisterByUsername(RegisterCompanyUserParam companyUserParam) {
        SysUser user = this.getCompanyUserByToken(companyUserParam.getToken(), companyUserParam.getUserType());
        if (user == null) {
            user = new SysUser();
            String salt = IdUtil.simpleUUID();
            user.setPassword(CommonsUtils.encryptPassword((String)"Zyj@2022", (String)salt)).setSalt(salt).setUserType(companyUserParam.getUserType()).setResource(SysUserResourceEnum.COMPANY_CAS_LOGIN.getValue()).setIsChangePwd(Integer.valueOf(Constant.NO)).setIsValid(Integer.valueOf(Constant.YES));
            if (this.isExistsUserName(companyUserParam.getUsername())) {
                companyUserParam.setUsername(companyUserParam.getUsername() + LocalDateTime.now().getSecond());
            }
            if (this.checkEmail(companyUserParam.getEmail(), null)) {
                user.setEmail(companyUserParam.getEmail());
            }
            this.msgService.pushMsg(new MsgDto(user.getId(), MsgTypeEnum.sys.getValue(), String.format("\u60a8\u7684\u8d26\u53f7\u4e3a\u201c%s\u201d\uff0c\u521d\u59cb\u5bc6\u7801\u4e3a\u201c%s\u201d\u3002", user.getUsername(), "Zyj@2022")));
        }
        if (user.getIsTest() == null || !user.getIsTest().equals(companyUserParam.getIsTest())) {
            user.setIsTest(companyUserParam.getIsTest());
        }
        if (user.getSuperviseIsHide() == null || !user.getSuperviseIsHide().equals(companyUserParam.getSuperviseIsHide())) {
            user.setSuperviseIsHide(companyUserParam.getSuperviseIsHide());
        }
        user.setUsername(companyUserParam.getUsername()).setName(companyUserParam.getCompanyName()).setResource(SysUserResourceEnum.COMPANY_CAS_LOGIN.getValue()).setAreaId(companyUserParam.getAreaId()).setIsTest(companyUserParam.getIsTest()).setIsForbidden(Integer.valueOf(Constant.NO)).setToken(companyUserParam.getToken());
        this.saveOrUpdate(user);
        if (Objects.equals(user.getUserType(), SysUserTypeEnum.COMPANY.getValue())) {
            HseBackCompany newHseCompany = this.hseBackCompanyService.getNewHseCompanyById(companyUserParam.getToken());
            if (null == newHseCompany) {
                throw new ServiceException("\u5355\u4f4d\u4fe1\u606f\u5f02\u5e38\uff01\u5355\u70b9\u767b\u5f55\u5931\u8d25");
            }
            this.hseBackCompanyService.saveOrUpdate(newHseCompany);
        } else if (Objects.equals(user.getUserType(), SysUserTypeEnum.ORG.getValue())) {
            HseBackCompany newHseOrg = this.hseBackCompanyService.getNewHseOrgById(companyUserParam.getToken());
            if (null == newHseOrg) {
                throw new ServiceException("\u673a\u6784\u4fe1\u606f\u5f02\u5e38\uff01\u5355\u70b9\u767b\u5f55\u5931\u8d25");
            }
            this.hseBackCompanyService.saveOrUpdate(newHseOrg);
        } else if (Objects.equals(user.getUserType(), SysUserTypeEnum.RAY_COMPANY.getValue())) {
            HseBackCompany newHseRayCompany = this.hseBackCompanyService.getNewRayCompanyById(companyUserParam.getToken());
            if (null == newHseRayCompany) {
                throw new ServiceException("\u533b\u9662\u4fe1\u606f\u5f02\u5e38\uff01\u5355\u70b9\u767b\u5f55\u5931\u8d25");
            }
            this.hseBackCompanyService.saveOrUpdate(newHseRayCompany);
        }
        return user;
    }

    @Override
    public void genUnitAccount() {
        List<Long> hseCidList = ((SysUserMapper)this.baseMapper).selectHseCidFromEnroll();
        if (hseCidList == null || hseCidList.size() == 0) {
            return;
        }
        List<HseBackCompany> hseCompanyInfoList = this.backCompanyService.listBackCompanyById(hseCidList);
        if (hseCompanyInfoList == null || hseCompanyInfoList.size() == 0) {
            return;
        }
        ArrayList<RegisterCompanyUserParam> regList = new ArrayList<RegisterCompanyUserParam>();
        for (HseBackCompany company : hseCompanyInfoList) {
            Integer userType = null;
            if (company.getSyncSourceType() == 1) {
                userType = SysUserTypeEnum.COMPANY.getValue();
            } else if (company.getSyncSourceType() == 3) {
                userType = SysUserTypeEnum.RAY_COMPANY.getValue();
            }
            RegisterCompanyUserParam reg = new RegisterCompanyUserParam();
            reg.setToken(company.getId());
            reg.setCompanyName(company.getName());
            reg.setUsername(company.getName());
            reg.setAreaId(company.getAreaId());
            reg.setCreditCode(company.getUnifiedSocialCc());
            reg.setIsTest(Integer.valueOf(company.getIsTest() != false ? 1 : 0));
            reg.setUserType(userType);
            regList.add(reg);
        }
        for (RegisterCompanyUserParam regInfo : regList) {
            SysUser user = this.getCompanyUserByToken(regInfo.getToken(), regInfo.getUserType());
            if (user == null) {
                user = new SysUser();
                String salt = IdUtil.simpleUUID();
                user.setPassword(CommonsUtils.encryptPassword((String)"Zyj@2022", (String)salt)).setSalt(salt).setUserType(regInfo.getUserType()).setResource(SysUserResourceEnum.COMPANY_TASK_REG.getValue()).setIsChangePwd(Integer.valueOf(Constant.NO)).setIsValid(Integer.valueOf(Constant.YES));
                if (this.isExistsUserName(regInfo.getUsername(), regInfo.getUserType())) {
                    regInfo.setUsername(regInfo.getUsername() + LocalDateTime.now().getSecond());
                }
            }
            user.setUsername(regInfo.getUsername()).setName(regInfo.getCompanyName()).setResource(SysUserResourceEnum.COMPANY_TASK_REG.getValue()).setAreaId(regInfo.getAreaId()).setIsTest(regInfo.getIsTest()).setIsForbidden(Integer.valueOf(Constant.NO)).setToken(regInfo.getToken());
            this.saveOrUpdate(user);
        }
    }

    @Override
    public void manuallyGenUnitAccount(Long cid) {
        List<Long> hseCidList = ((SysUserMapper)this.baseMapper).selectHseCidFromEnrollByManual(cid);
        if (hseCidList == null || hseCidList.size() == 0) {
            return;
        }
        List<HseBackCompany> hseCompanyInfoList = this.backCompanyService.listBackCompanyById(hseCidList);
        if (hseCompanyInfoList == null || hseCompanyInfoList.size() == 0) {
            return;
        }
        ArrayList<RegisterCompanyUserParam> regList = new ArrayList<RegisterCompanyUserParam>();
        for (HseBackCompany company : hseCompanyInfoList) {
            Integer userType = null;
            if (company.getSyncSourceType() == 1) {
                userType = SysUserTypeEnum.COMPANY.getValue();
            } else if (company.getSyncSourceType() == 3) {
                userType = SysUserTypeEnum.RAY_COMPANY.getValue();
            }
            RegisterCompanyUserParam reg = new RegisterCompanyUserParam();
            reg.setToken(company.getId());
            reg.setCompanyName(company.getName());
            reg.setUsername(company.getName());
            reg.setAreaId(company.getAreaId());
            reg.setCreditCode(company.getUnifiedSocialCc());
            reg.setIsTest(Integer.valueOf(company.getIsTest() != false ? 1 : 0));
            reg.setUserType(userType);
            regList.add(reg);
        }
        for (RegisterCompanyUserParam regInfo : regList) {
            SysUser user = this.getCompanyUserByToken(regInfo.getToken(), SysUserTypeEnum.COMPANY.getValue());
            if (user == null) {
                user = new SysUser();
                String salt = IdUtil.simpleUUID();
                user.setPassword(CommonsUtils.encryptPassword((String)"Zyj@2022", (String)salt)).setSalt(salt).setUserType(regInfo.getUserType()).setResource(SysUserResourceEnum.COMPANY_TASK_REG.getValue()).setIsChangePwd(Integer.valueOf(Constant.NO)).setIsValid(Integer.valueOf(Constant.YES));
                if (this.isExistsUserName(regInfo.getUsername(), regInfo.getUserType())) {
                    regInfo.setUsername(regInfo.getUsername() + LocalDateTime.now().getSecond());
                }
            }
            user.setUsername(regInfo.getUsername()).setName(regInfo.getCompanyName()).setResource(SysUserResourceEnum.COMPANY_TASK_REG.getValue()).setAreaId(regInfo.getAreaId()).setIsTest(regInfo.getIsTest()).setIsForbidden(Integer.valueOf(Constant.NO)).setToken(regInfo.getToken());
            this.saveOrUpdate(user);
        }
    }

    private void checkCNameAndCreditCode(String cname, String creditCode) {
        SysCompany companyByName = this.companyService.getCompanyByName(cname);
        if (companyByName != null) {
            throw new ServiceException("\u8be5\u516c\u53f8\u540d\u79f0\u5df2\u88ab\u6ce8\u518c\uff01");
        }
        SysCompany companyByCreditCode = this.companyService.getCompanyByCreditCode(creditCode);
        if (companyByCreditCode != null) {
            throw new ServiceException("\u8be5\u516c\u53f8\u4f01\u4e1a\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5df2\u88ab\u6ce8\u518c\uff01");
        }
    }

    private boolean isExistsUserName(String userName) {
        return this.isExistsUserName(userName, null);
    }

    private boolean isExistsUserName(String userName, Integer userType) {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            return false;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysUser::getUsername, (Object)userName)).eq(BaseBean::getIsValid, (Object)true)).last("limit 1");
        if (userType != null) {
            wrapper.eq(SysUser::getUserType, (Object)userType);
        } else {
            wrapper.eq(SysUser::getUserType, (Object)SysUserTypeEnum.COMPANY.getValue());
        }
        return this.getOne((Wrapper)wrapper) != null;
    }

    private boolean checkUsername(String userName, Long userId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysUser::getUsername, (Object)userName)).eq(BaseBean::getIsValid, (Object)true)).eq(SysUser::getUserType, (Object)SysUserTypeEnum.USER.getValue())).last("limit 1");
        SysUser user = (SysUser)this.getOne((Wrapper)wrapper);
        return user == null || user.getId().equals(userId);
    }

    private boolean isExistsUserNameFromUser(String userName) {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            return false;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysUser::getUsername, (Object)userName)).eq(BaseBean::getIsValid, (Object)true)).eq(SysUser::getUserType, (Object)SysUserTypeEnum.USER.getValue())).last("limit 1");
        return this.getOne((Wrapper)wrapper) != null;
    }

    private boolean isExistsPhone(String phone) {
        if (StringUtils.isEmpty((CharSequence)phone)) {
            return false;
        }
        return this.getUserByPhone(phone) != null;
    }

    private boolean isExistsEmail(String email) {
        if (StringUtils.isEmpty((CharSequence)email)) {
            return false;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysUser::getEmail, (Object)email)).eq(BaseBean::getIsValid, (Object)true)).last("limit 1");
        return this.getOne((Wrapper)wrapper) != null;
    }

    private boolean isExistsIdCard(String idCard) {
        return this.getOneByIdCard(idCard) != null;
    }

    @Override
    public SysUser getOneByEmail(String email) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysUser::getEmail, (Object)email)).eq(BaseBean::getIsValid, (Object)true)).last("limit 1");
        return (SysUser)this.getOne((Wrapper)wrapper);
    }

    @Override
    public SysUser getOneByIdCard(String idCard) {
        return ((SysUserMapper)this.baseMapper).getUserByIdCard(idCard);
    }

    @Override
    @Transactional
    public void editPersonal(EditUserParam param) {
        SysUserInfo userInfo;
        if (param.getIdcard() != null && param.getIdcardType() == null) {
            throw new ServiceException("\u8bc1\u4ef6\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (param.getIdcardType() != null && !IdcardTypeEnum.contain((Integer)param.getIdcardType())) {
            throw new ServiceException("\u8bc1\u4ef6\u7c7b\u578b\u9519\u8bef");
        }
        if (!this.checkIdCard(param.getIdcard(), param.getId())) {
            throw new ServiceException(String.format("\u8bc1\u4ef6\u53f7\u4e0d\u53ef\u7528", new Object[0]));
        }
        if (!(StringUtils.isEmpty((CharSequence)param.getName()) && StringUtils.isEmpty((CharSequence)param.getEmail()) && StringUtils.isEmpty((CharSequence)param.getAvatar()))) {
            SysUser user = new SysUser().setId(param.getId()).setName(param.getName()).setEmail(param.getEmail()).setAvatar(param.getAvatar());
            this.updateById(user);
        }
        userInfo = (userInfo = this.userInfoService.getSysUserInfo(param.getId())) == null ? new SysUserInfo() : userInfo;
        userInfo.setName(param.getName()).setIdcard(param.getIdcard()).setIdcardType(param.getIdcardType()).setPhotoUrl(param.getPhotoUrl()).setEducation(param.getEducation()).setWorkType(param.getWorkType()).setRadiationWorkDate(param.getRadiationWorkDate()).setSex(param.getSex()).setUpdateDate(null);
        this.userInfoService.saveOrUpdate(userInfo);
    }

    @Override
    @Transactional
    public void editXhPersonal(EditUserParam param) {
        if (param.getId() == null || param.getIdcard() == null || StrUtil.isBlank((CharSequence)param.getName())) {
            throw new ServiceException("\u4fe1\u606f\u4e0d\u5168");
        }
        if (!this.checkIdCard(param.getIdcard(), param.getId())) {
            throw new ServiceException("\u8eab\u4efd\u8bc1\u4e0d\u6b63\u786e");
        }
        SysUser sysUser = (SysUser)this.getById(param.getId());
        if (sysUser == null) {
            throw new ServiceException("\u7f16\u8f91\u5931\u8d25");
        }
        SysUserInfo userInfo = this.userInfoService.getSysUserInfo(param.getId());
        SysUserInfo sysUserInfo = userInfo = userInfo == null ? new SysUserInfo() : userInfo;
        if (StrUtil.isNotBlank((CharSequence)userInfo.getIdcard())) {
            throw new ServiceException("\u65e0\u6cd5\u7f16\u8f91");
        }
        SysUser user = new SysUser().setId(param.getId()).setName(param.getName());
        this.updateById(user);
        userInfo.setName(param.getName()).setIdcard(param.getIdcard()).setIdcardType(IdcardTypeEnum.CHINESE_IDENTITY_CARD.getValue());
        this.userInfoService.saveOrUpdate(userInfo);
    }

    @Transactional
    public void coverHSEInfo(EditUserParam param) {
        TrainAttendModel trainAttendModel = new TrainAttendModel();
        trainAttendModel.setTrainUserId(param.getLoginUserId());
        trainAttendModel.setIdCard(param.getOldIdcard());
        trainAttendModel.setNewIdCard(param.getCoverType() == 3 ? param.getIdcard() : null);
        trainAttendModel.setStaffName(param.getName());
        trainAttendModel.setOperationType(param.getCoverType());
        TrainStaffInfoModel trainStaffInfoModel = this.syncTrainInfoService.getOrUpdateStaffInfo(trainAttendModel);
        if (trainStaffInfoModel.getMessage() != null) {
            // empty if block
        }
    }

    private Integer countResidualTimes(EditUserParam param, SysUserInfo userInfo) {
        if (param.getCoverType() != null && (param.getCoverType() == 2 || param.getCoverType() == 3)) {
            return 0;
        }
        int max = 1;
        Integer residueIdcardLimit = userInfo.getResidueIdcardLimit();
        residueIdcardLimit = residueIdcardLimit == null ? max : residueIdcardLimit;
        residueIdcardLimit = residueIdcardLimit > max ? max : residueIdcardLimit;
        if (StringUtils.isEmpty((CharSequence)userInfo.getIdcard())) {
            residueIdcardLimit = max;
        } else if (!StringUtils.isEmpty((CharSequence)param.getIdcard()) && !param.getIdcard().equals(userInfo.getIdcard()) && (residueIdcardLimit = Integer.valueOf(residueIdcardLimit - 1)) < 0) {
            throw new ServiceException("\u8eab\u4efd\u8bc1\u4fee\u6539\u6b21\u6570\u5df2\u7ecf\u7528\u5b8c\uff0c\u65e0\u6cd5\u4fee\u6539\u8eab\u4efd\u8bc1");
        }
        return residueIdcardLimit;
    }

    @Override
    public Integer getEnrollTime(Long uid) {
        return ((SysUserMapper)this.baseMapper).getEnrollTime(uid);
    }

    @Override
    public void ifCanEditPersonalUserBatch(List<Long> idList, String loginUsername, Integer userType, Integer userOptRole, Long superviseArea) {
        if (AccountUtil.isSpecifiedUserName((String)loginUsername)) {
            return;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        for (Long uid : idList) {
            String result = this.ifCanEditPersonalUserSingle(uid, loginUsername, userType, userOptRole, superviseArea);
            if (result == null) continue;
            resultList.add(uid + ":" + result);
        }
        if (!CollectionUtils.isEmpty(resultList)) {
            if (idList.size() == 1) {
                throw new ServiceException(Integer.valueOf(1), ((String)resultList.get(0)).split(":")[1], resultList);
            }
            throw new ServiceException(Integer.valueOf(1), "\u5931\u8d25", resultList);
        }
    }

    @Override
    public void ifCanRmForPersonal(List<Long> idList, String loginUsername, Integer userFrom, Integer useOptRole) {
        if (!AccountUtil.isSpecifiedUserName((String)loginUsername)) {
            throw new ServiceException("\u65e0\u5220\u9664\u6743\u9650");
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Long uid : idList) {
            String s = this.ifCanRM(uid);
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            result.add(s);
        }
        if (!CollectionUtils.isEmpty(result)) {
            throw new ServiceException(Integer.valueOf(1), "\u5f53\u524d\u7528\u6237\u5df2\u6709\u57f9\u8bad\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664");
        }
    }

    private String ifCanRM(Long uid) {
        Integer enrollTime = this.userService.getEnrollTime(uid);
        if (enrollTime != null && enrollTime > 0) {
            return "\u5f53\u524d\u7528\u6237\u5df2\u6709\u57f9\u8bad\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664";
        }
        return null;
    }

    private String ifCanEditPersonalUserSingle(Long uid, String loginUsername, Integer userType, Integer userOptRole, Long superviseArea) {
        if (AccountUtil.isSpecifiedUserName((String)loginUsername)) {
            return null;
        }
        if (AccountUtil.isGeneralMaintenance((Integer)userType, (Integer)userOptRole)) {
            return "\u666e\u901a\u8fd0\u7ef4\u65e0\u8be5\u7528\u6237\u7684\u7f16\u8f91\u6743\u9650";
        }
        if (superviseArea.equals(0)) {
            return "\u76d1\u7ba1\u5355\u4f4d\u533a\u57df\u5f02\u5e38";
        }
        List<SysCompanyStaff> sysCompanyStaffList = this.sysCompanyStaffService.getInfoByUID(uid);
        if (CollectionUtils.isEmpty(sysCompanyStaffList)) {
            return null;
        }
        List<Long> cidList = sysCompanyStaffList.stream().map(SysCompanyStaff::getCid).collect(Collectors.toList());
        List<HseCompanyVo> hseCompanyVoList = this.hseCompanyService.getInfosByIds(cidList);
        List careaIdLIst = hseCompanyVoList.stream().map(HseCompanyVo::getAreaId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(careaIdLIst)) {
            return null;
        }
        boolean flag = false;
        for (Long aLong : careaIdLIst) {
            AreaDto superviseAreaDto = this.sysAreaService.getAreaById(superviseArea);
            AreaDto companyArea = this.sysAreaService.getAreaById(aLong);
            if (superviseAreaDto.getLevel() > companyArea.getLevel()) {
                flag = false;
                continue;
            }
            if (superviseAreaDto.getLevel() == 1) {
                flag = true;
                break;
            }
            if (superviseAreaDto.getLevel() == 2) {
                if (!superviseAreaDto.getCityId().equals(companyArea.getCityId())) continue;
                flag = true;
                break;
            }
            if (superviseAreaDto.getLevel() == 3) {
                if (!superviseAreaDto.getAreaId().equals(companyArea.getAreaId())) continue;
                flag = true;
                break;
            }
            if (superviseAreaDto.getLevel() == 4) {
                if (!superviseAreaDto.getStreetId().equals(companyArea.getStreetId())) continue;
                flag = true;
                break;
            }
            throw new ServiceException("\u533a\u57df\u6821\u9a8c\u5931\u8d25");
        }
        if (!flag) {
            return "\u65e0\u8be5\u7528\u6237\u7684\u7f16\u8f91\u6743\u9650";
        }
        return null;
    }

    @Override
    @Transactional
    public void changePasswordRegularly() {
        ((SysUserMapper)this.baseMapper).updateChangePasswordRegularly();
    }

    @Override
    public SysUser getUserByZlbUserId(String zlbUserId) {
        if (StringUtils.isEmpty((CharSequence)zlbUserId)) {
            return null;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysUser::getZlbUserId, (Object)zlbUserId)).eq(BaseBean::getIsValid, (Object)true)).last("limit 1");
        return (SysUser)this.getOne((Wrapper)wrapper);
    }

    @Override
    public List<Long> selectAllWxUserId() {
        return ((SysUserMapper)this.baseMapper).selectAllWxUserId();
    }

    @Override
    public void unbindZlbUserId(Long userId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(SysUser::getId, (Object)userId)).eq(BaseBean::getIsValid, (Object)true)).set(SysUser::getZlbUserId, null);
        this.update((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void bindIdcard(Long userId, String name, String idcard, Integer idcardType, Long areaId) {
        SysUserInfo userInfo;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name})) {
            SysUser sysUser = new SysUser();
            sysUser.setId(userId);
            sysUser.setName(name);
            sysUser.setAreaId(areaId);
            ((SysUserMapper)this.baseMapper).updateById(sysUser);
        }
        if ((userInfo = this.userInfoService.getSysUserInfo(userId)) == null) {
            userInfo = new SysUserInfo();
            userInfo.setUserId(userId);
        }
        userInfo.setName(name);
        userInfo.setIdcard(idcard);
        userInfo.setIdcardType(idcardType);
        userInfo.setAreaId(areaId);
        this.userInfoService.saveOrUpdate(userInfo);
    }

    @Override
    public long getSameUsernameCount(String usernamePrefix) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.likeRight(SysUser::getUsername, (Object)usernamePrefix)).eq(BaseBean::getIsValid, (Object)true);
        return ((SysUserMapper)this.baseMapper).selectCount((Wrapper)wrapper);
    }

    @Override
    public void modifyLoginMsStatus(Long id) {
        SysUser sysUser = new SysUser();
        sysUser.setId(id);
        sysUser.setHasRegisteredXh(Integer.valueOf(1));
        this.updateById(sysUser);
    }

    @Generated
    public SysUserServiceImpl() {
    }
}

