/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.user.impl;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.radiationTraining.modules.sys.dao.user.SysRoleMapper;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysRole;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUserRole;
import cn.smarthse.radiationTraining.modules.sys.service.user.ISysRoleService;
import cn.smarthse.radiationTraining.modules.sys.service.user.ISysUserRoleService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class SysRoleServiceImpl
extends ServiceImpl<SysRoleMapper, SysRole>
implements ISysRoleService {
    private final ISysUserRoleService userRoleService;

    public List<SysRole> selectRoleList(Long userId) {
        Set<Long> roleIds = this.userRoleService.selectRoleIdByUserId(userId);
        if (CollUtil.isEmpty(roleIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{SysRole::getId, SysRole::getSrName, SysRole::getSrKey}).in(SysRole::getId, roleIds);
        return this.list((Wrapper)queryWrapper);
    }

    public boolean addRole(Long userId, Long ... roleIds) {
        List userRoles = Arrays.stream(roleIds).map(roleId -> {
            SysUserRole userRole = new SysUserRole();
            userRole.setUserId(userId);
            userRole.setRoleId(roleId);
            return userRole;
        }).collect(Collectors.toList());
        return this.userRoleService.saveBatch(userRoles);
    }

    @Generated
    public SysRoleServiceImpl(ISysUserRoleService userRoleService) {
        this.userRoleService = userRoleService;
    }
}

