/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.sys.impl;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.modules.sys.dao.sys.SysSettingMapper;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysSetting;
import cn.smarthse.radiationTraining.modules.sys.param.sys.ParamQueryParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.SaveSysSettingParam;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysSettingService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysSettingVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.annotation.Method;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.transaction.annotation.Transactional;

@DubboService(methods={@Method(name="getSettingListData"), @Method(name="saveSetting"), @Method(name="getSettingFromDB"), @Method(name="getApiSettingList"), @Method(name="getAndroidAppUrl"), @Method(name="getAppleAppUrl")})
public class SysSettingServiceImpl
extends ServiceImpl<SysSettingMapper, SysSetting>
implements ISysSettingService {
    @Autowired
    private OssClientBean ossClientBean;

    public LayuiGridData<SysSettingVo> getSettingListData(ParamQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        return new LayuiGridData((Page)((SysSettingMapper)this.baseMapper).getSettingList(param), (LayuiGridParam)param);
    }

    @Transactional
    @CacheEvict(value={"SYSSETTING"}, key="1")
    @Caching(evict={@CacheEvict(value={"SYSSETTING"}, key="1"), @CacheEvict(value={"SYSSETTING"}, key="#param.code")})
    public void saveSetting(SaveSysSettingParam param) {
        SysSetting record = new SysSetting();
        record.setId(param.getId());
        record.setName(param.getName());
        record.setValue(param.getValue());
        record.setDesc(param.getDesc());
        record.setUpdator(param.getLoginName());
        if (!this.checkCode(param.getCode(), param.getId())) {
            throw new ServiceException(String.format("\u7cfb\u7edf\u53c2\u6570\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728", param.getCode()));
        }
        if (param.getId() == null) {
            record.setCode(param.getCode());
            record.setCreateBy(param.getLoginUserId());
        } else {
            record.setUpdateBy(param.getLoginUserId());
        }
        this.saveOrUpdate(record);
    }

    @Cacheable(cacheNames={"SYSSETTING"}, key="1")
    public List<SysSettingVo> getApiSettingList() {
        return ((SysSettingMapper)this.baseMapper).getApiSettingList();
    }

    @Cacheable(cacheNames={"SYSSETTING"}, key="#code")
    public SysSettingVo getSetting(String code) {
        return ((SysSettingMapper)this.baseMapper).getSetting(code);
    }

    @Cacheable(cacheNames={"SYSSETTING:TYPE"}, key="#type")
    public List<SysSettingVo> getSettingByType(String type) {
        return ((SysSettingMapper)this.baseMapper).getSettingByType(type);
    }

    public SysSettingVo getSettingFromDB(String code) {
        return ((SysSettingMapper)this.baseMapper).getSetting(code);
    }

    public String getAndroidAppUrl() {
        SysSettingVo vo = ((SysSettingMapper)this.baseMapper).getSetting("app-android-url");
        if (vo == null) {
            return null;
        }
        String url = vo.getValue();
        return this.ossClientBean.getUrl(url);
    }

    public String getAppleAppUrl() {
        SysSettingVo vo = ((SysSettingMapper)this.baseMapper).getSetting("app-apple-url");
        if (vo == null) {
            return null;
        }
        String url = vo.getValue();
        return this.ossClientBean.getUrl(url);
    }

    private boolean checkCode(String code, Long id) {
        SysSetting record = this.getByCode(code);
        return record == null || record.getId().equals(id);
    }

    private SysSetting getByCode(String code) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysSetting::getCode, (Object)code)).eq(BaseBean::getIsValid, (Object)Constant.YES)).last("limit 1");
        return (SysSetting)this.getOne((Wrapper)queryWrapper);
    }
}

