/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.modules.sys.dao.sys.SysParamMapper;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysParam;
import cn.smarthse.radiationTraining.modules.sys.param.ForbiddenParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.ParamQueryParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.SaveSysParam;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysParamService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysParamVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SysParamServiceImpl
extends ServiceImpl<SysParamMapper, SysParam>
implements ISysParamService {
    private static final Long START_ID = 100L;
    private static final String START_INDEX = "001";
    private static final String DEFAULT_PCODE = "0";
    private static final Long DEFAULT_PID = 0L;

    @Override
    public List<SysParamVo> getParamList(ParamQueryParam param) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        if (StrUtil.isBlank((CharSequence)param.getPcode())) {
            param.setPcode(DEFAULT_PCODE);
        }
        queryWrapper.eq(SysParam::getPcode, (Object)param.getPcode());
        return ((SysParamMapper)this.baseMapper).getParamList(param);
    }

    @Override
    public LayuiGridData<SysParamVo> getParamListData(ParamQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        return new LayuiGridData((Page)this.getParamList(param), (LayuiGridParam)param);
    }

    @Override
    @Transactional
    @CacheEvict(value={"SYS:PARAM"}, key="#param.id", condition="#param.id != null")
    public void saveParam(SaveSysParam param) {
        param.setPid(Long.valueOf(param.getPid() == null ? 0L : param.getPid()));
        if (!this.checkName(param.getName(), param.getId(), param.getPid())) {
            throw new ServiceException(String.format("\u6570\u636e\u5b57\u5178\u201c%s\u201d\u5df2\u5b58\u5728", param.getName()));
        }
        SysParam sysParam = new SysParam();
        sysParam.setId(param.getId());
        sysParam.setName(param.getName());
        sysParam.setDescription(param.getDesc());
        sysParam.setUpdator(param.getLoginName());
        sysParam.setIsDefault(Integer.valueOf(param.getIsDefault() == null ? 0 : param.getIsDefault()));
        if (param.getId() == null) {
            SysParam pSysParam = (SysParam)this.getById(param.getPid());
            sysParam.setPcode(pSysParam == null ? DEFAULT_PCODE : pSysParam.getCode());
            sysParam.setPid(Long.valueOf(Long.parseLong(sysParam.getPcode())));
            sysParam.setCode(this.generateCode(sysParam.getPcode()));
            sysParam.setId(Long.valueOf(Long.parseLong(sysParam.getCode())));
            sysParam.setCreateBy(param.getLoginUserId());
            this.save(sysParam);
        } else {
            sysParam.setUpdateBy(param.getLoginUserId());
            this.updateById(sysParam);
        }
    }

    private SysParam getByName(String name, Long pid) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysParam::getName, (Object)name)).eq(BaseBean::getIsValid, (Object)Constant.YES)).last("limit 1");
        if (pid == null || pid == 0L) {
            queryWrapper.eq(SysParam::getPid, (Object)0L);
        } else {
            queryWrapper.likeRight(SysParam::getPid, (Object)pid);
        }
        return (SysParam)this.getOne((Wrapper)queryWrapper);
    }

    private boolean checkName(String name, Long id, Long pid) {
        SysParam record = this.getByName(name, pid);
        return record == null || record.getId().equals(id);
    }

    @Override
    @Transactional
    public void delParam(IdsParam param) {
        if (CollectionUtils.isEmpty((Collection)param.getIdList())) {
            throw new ServiceException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\uff01");
        }
        this.checkRm(param.getIdList());
        Wrapper wrapper = (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().in(SysParam::getId, (Collection)param.getIdList())).eq(BaseBean::getIsValid, (Object)Constant.YES);
        SysParam record = new SysParam();
        record.setUpdateBy(param.getLoginUserId());
        record.setUpdator(param.getLoginName());
        record.setUpdateDate(LocalDateTime.now());
        this.update(record, wrapper);
        this.removeByIds(param.getIdList());
    }

    public void checkRm(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        List list = this.listByIds(idList);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (SysParam sysParam : list) {
            int num;
            if (sysParam.getIsDefault() == 1) {
                throw new ServiceException("\u65e0\u6cd5\u5220\u9664\u7cfb\u7edf\u9ed8\u8ba4\u7c7b\u578b");
            }
            if (!StrUtil.isNotEmpty((CharSequence)sysParam.getPcode()) || !sysParam.getPcode().equals("500") || (num = ((SysParamMapper)this.baseMapper).selectedNumForArticleVideo(sysParam.getId())) <= 0) continue;
            throw new ServiceException("\u5df2\u88ab\u6587\u7ae0\u89c6\u9891\u6a21\u5757\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
        }
    }

    private boolean checkDel(List<Long> idList) {
        Wrapper wrapper = (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysParam::getId, idList)).eq(SysParam::getIsForbidden, (Object)1)).eq(BaseBean::getIsValid, (Object)Constant.YES);
        return this.count(wrapper) == (long)idList.size();
    }

    @Override
    @Transactional
    public void forbiddenParam(ForbiddenParam param) {
        Wrapper wrapper = (Wrapper)Wrappers.lambdaUpdate().in(SysParam::getId, (Collection)param.getIdList());
        SysParam record = new SysParam();
        record.setIsForbidden(param.getIsForbidden());
        record.setUpdateBy(param.getLoginUserId());
        record.setUpdator(param.getLoginName());
        this.update(record, wrapper);
    }

    private String generateCode(String pcode) {
        Long maxId;
        if (pcode == null) {
            pcode = DEFAULT_PCODE;
        }
        if ((maxId = ((SysParamMapper)this.baseMapper).getMaxId(pcode)) == null) {
            if (pcode.equals(DEFAULT_PCODE)) {
                return START_ID.toString();
            }
            return Long.parseLong(pcode) + START_INDEX;
        }
        return String.valueOf(maxId + 1L);
    }

    @Override
    public List<String> getNamesByTypeAndCodes(String pcode, List<String> codes) {
        List<SysParam> sysParams = this.getByTypeAndCodes(pcode, codes);
        if (sysParams == null) {
            return null;
        }
        return sysParams.stream().map(SysParam::getName).collect(Collectors.toList());
    }

    @Override
    public List<SysParam> getByTypeAndCodes(String pcode, List<String> codes) {
        QueryWrapper sysParamQueryWrapper = new QueryWrapper();
        ((QueryWrapper)sysParamQueryWrapper.eq((Object)"pcode", (Object)pcode)).in((Object)"code", codes);
        return ((SysParamMapper)this.baseMapper).selectList((Wrapper)sysParamQueryWrapper);
    }

    @Override
    public List<SysParam> getByTypeAndKeyword(String pcode, String keyword) {
        QueryWrapper sysParamQueryWrapper = new QueryWrapper();
        ((QueryWrapper)sysParamQueryWrapper.eq((Object)"pcode", (Object)pcode)).like(StringUtils.isNotBlank((String)keyword), (Object)"name", (Object)keyword);
        return ((SysParamMapper)this.baseMapper).selectList((Wrapper)sysParamQueryWrapper);
    }

    @Override
    public List<String> getNamesByCodes(List<String> codes) {
        return this.getByCodes(codes).stream().map(SysParam::getName).collect(Collectors.toList());
    }

    @Override
    public List<SysParam> getByCodes(List<String> codes) {
        if (codes != null && codes.size() > 0) {
            QueryWrapper sysParamQueryWrapper = new QueryWrapper();
            sysParamQueryWrapper.in((Object)"code", codes);
            return ((SysParamMapper)this.baseMapper).selectList((Wrapper)sysParamQueryWrapper);
        }
        return new ArrayList<SysParam>();
    }

    @Override
    @Cacheable(value={"SYS:PARAM"}, key="#workTypeCode")
    public SysParam getByCode(String workTypeCode) {
        QueryWrapper sysParamQueryWrapper = new QueryWrapper();
        sysParamQueryWrapper.eq((Object)"code", (Object)workTypeCode);
        return (SysParam)((SysParamMapper)this.baseMapper).selectOne((Wrapper)sysParamQueryWrapper);
    }

    @Override
    public String getNameByCode(String workTypeCode) {
        SysParam param = this.getByCode(workTypeCode);
        return param == null ? "" : param.getName();
    }

    @Override
    public String getCodesByNames(List<String> names) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.like(SysParam::getPcode, (Object)"100%");
        wrapper.in(SysParam::getName, names);
        List resultList = ((SysParamMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return null;
        }
        return resultList.stream().map(SysParam::getCode).collect(Collectors.joining(","));
    }

    @Override
    public String getOccExpCodeByPcode(String pcode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysParam::getPcode, (Object)pcode)).eq(BaseBean::getIsValid, (Object)true)).like(SysParam::getPcode, (Object)"100%");
        wrapper.orderByDesc(BaseBean::getCreateDate);
        SysParam result = (SysParam)((SysParamMapper)this.baseMapper).selectOne((Wrapper)wrapper);
        if (result == null || StringUtils.isEmpty((String)result.getName())) {
            return "";
        }
        return result.getName();
    }

    @Generated
    public SysParamServiceImpl() {
    }
}

