/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.sys.impl;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.dao.sys.SysOccupationalHazardsMapper;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysOccupationalHazards;
import cn.smarthse.radiationTraining.modules.sys.param.sys.OccHazardsQueryParam;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysOccupationalHazardsService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.OccHazardsVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class SysOccupationalHazardsServiceImpl
extends ServiceImpl<SysOccupationalHazardsMapper, SysOccupationalHazards>
implements ISysOccupationalHazardsService {
    @Override
    public List<SysOccupationalHazards> getAllHazards() {
        List<SysOccupationalHazards> all = this.getAll();
        HashMap<Long, SysOccupationalHazards> hazardsMap = new HashMap<Long, SysOccupationalHazards>();
        HashMap<Long, List> pidHazardsMap = new HashMap<Long, List>();
        for (SysOccupationalHazards hazards : all) {
            hazardsMap.put(hazards.getId(), hazards);
            List list = pidHazardsMap.computeIfAbsent(hazards.getPid(), k -> new LinkedList());
            list.add(hazards);
        }
        all.sort(Comparator.comparing(SysOccupationalHazards::getId));
        return all;
    }

    public List<SysOccupationalHazards> getAll() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysOccupationalHazards::getIsValid, (Object)Constant.YES);
        return this.list((Wrapper)queryWrapper);
    }

    public SysOccupationalHazards getMaxCodeOneByPid(Long pid) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysOccupationalHazards::getIsValid, (Object)Constant.YES)).eq(SysOccupationalHazards::getPid, (Object)pid);
        List list = this.list((Wrapper)queryWrapper);
        if (list.size() > 0 && !((SysOccupationalHazards)list.get(0)).getType().equals("QT") && Integer.parseInt(((SysOccupationalHazards)list.get(0)).getCode()) - Integer.parseInt(((SysOccupationalHazards)list.get(1)).getCode()) > 1) {
            return (SysOccupationalHazards)list.get(1);
        }
        return (SysOccupationalHazards)list.get(0);
    }

    @Override
    @Transactional(readOnly=false)
    public void addHazards(SysOccupationalHazards hazards) {
        if (hazards.getPid() == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef\uff01");
        }
        SysOccupationalHazards maxCodeHazards = this.getMaxCodeOneByPid(hazards.getPid());
        if (maxCodeHazards == null) {
            SysOccupationalHazards pHazards = (SysOccupationalHazards)this.getById(hazards.getPid());
            if (pHazards == null) {
                throw new ServiceException("\u53c2\u6570\u9519\u8bef\uff01");
            }
            hazards.setLevel(Integer.valueOf(pHazards.getLevel() + 1));
            hazards.setType(pHazards.getType());
            if (StringUtils.isNotEmpty((String)hazards.getCode())) {
                hazards.setCode(pHazards.getCode().concat("001"));
            }
        } else {
            hazards.setLevel(maxCodeHazards.getLevel());
            hazards.setType(maxCodeHazards.getType());
            hazards.setCode(Integer.valueOf(maxCodeHazards.getCode()) + 1 + "");
        }
        this.save(hazards);
    }

    @Override
    public SysOccupationalHazards getByName(String name) {
        if (name.isEmpty()) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysOccupationalHazards::getIsValid, (Object)Constant.YES)).eq(SysOccupationalHazards::getName, (Object)name);
        List list = this.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            return (SysOccupationalHazards)list.get(0);
        }
        return null;
    }

    @Override
    public Map<String, String> nameToCodeMap() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysOccupationalHazards::getIsValid, (Object)Constant.YES);
        List list = this.list((Wrapper)queryWrapper);
        HashMap<String, String> map = new HashMap<String, String>();
        for (SysOccupationalHazards hazards : list) {
            map.put(hazards.getName(), hazards.getCode());
        }
        return map;
    }

    @Override
    public Integer getHazardsLevel(String hazardsCode) {
        if (StringUtils.isBlank((CharSequence)hazardsCode)) {
            return 0;
        }
        SysOccupationalHazards hazards = this.getByCode(hazardsCode);
        return hazards == null ? 0 : hazards.getLevel();
    }

    @Override
    public SysOccupationalHazards getByCode(String code) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysOccupationalHazards::getIsValid, (Object)Constant.YES)).eq(SysOccupationalHazards::getCode, (Object)code);
        return (SysOccupationalHazards)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<SysOccupationalHazards> getByCodes(List<String> codes) {
        if (codes != null && codes.size() > 0) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"code", codes);
            return ((SysOccupationalHazardsMapper)this.baseMapper).selectList((Wrapper)wrapper);
        }
        return new ArrayList<SysOccupationalHazards>();
    }

    @Override
    public List<String> getNamesByCodes(List<String> codes) {
        return this.getByCodes(codes).stream().map(SysOccupationalHazards::getName).collect(Collectors.toList());
    }

    @Override
    public String getNameStrByCodeStr(String codeStr) {
        if (codeStr == null) {
            return null;
        }
        List<String> nameList = this.getNamesByCodes(Arrays.asList(codeStr.split(",")));
        return StringUtils.join(nameList, (String)"\uff0c");
    }

    @Override
    public String getCodesByNames(List<String> typeNames) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(SysOccupationalHazards::getName, typeNames);
        List resultList = ((SysOccupationalHazardsMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return null;
        }
        return resultList.stream().map(SysOccupationalHazards::getCode).collect(Collectors.joining(","));
    }

    @Override
    public LayuiGridData<OccHazardsVo> queryPage(OccHazardsQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<OccHazardsVo> list = ((SysOccupationalHazardsMapper)this.baseMapper).queryPage(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public List<OccHazardsVo> queryTree(OccHazardsQueryParam param) {
        return this.querytTreeByKeyword(param);
    }

    private List<OccHazardsVo> queryTreeAll() {
        List<OccHazardsVo> voList = ((SysOccupationalHazardsMapper)this.baseMapper).getAllVo();
        List<OccHazardsVo> typeList = voList.stream().filter(v -> v.getLevel() == 1).collect(Collectors.toList());
        List childFactor = voList.stream().filter(v -> v.getLevel() == 2).collect(Collectors.toList());
        Map<String, List<OccHazardsVo>> childFactorMap = childFactor.stream().collect(Collectors.groupingBy(v -> v.getType()));
        for (OccHazardsVo type : typeList) {
            if (type.getChild() == null) {
                type.setChild(new ArrayList());
            }
            type.getChild().addAll((Collection)childFactorMap.get(type.getType()));
        }
        return typeList;
    }

    private List<OccHazardsVo> querytTreeByKeyword(OccHazardsQueryParam param) {
        List<OccHazardsVo> voList = ((SysOccupationalHazardsMapper)this.baseMapper).queryPage(param);
        List<OccHazardsVo> typeList = voList.stream().filter(v -> v.getLevel() == 1).collect(Collectors.toList());
        Map<String, OccHazardsVo> typeMap = typeList.stream().collect(Collectors.toMap(v -> v.getType(), v -> v));
        List childFactor = voList.stream().filter(v -> v.getLevel() == 2).collect(Collectors.toList());
        Map<String, List<OccHazardsVo>> childFactorMap = childFactor.stream().collect(Collectors.groupingBy(v -> v.getType()));
        Set<String> typeSet = childFactorMap.keySet();
        for (String type : typeSet) {
            if (typeMap.containsKey(type)) continue;
            OccHazardsVo vo = ((SysOccupationalHazardsMapper)this.baseMapper).getVoByCode(String.valueOf(type));
            typeList.add(vo);
        }
        for (OccHazardsVo vo : typeList) {
            if (vo.getChild() == null) {
                vo.setChild(new ArrayList());
            }
            if (childFactorMap.get(vo.getType()) == null) continue;
            vo.getChild().addAll((Collection)childFactorMap.get(vo.getType()));
        }
        return typeList;
    }

    @Override
    public Long getProgenyNum(String code, Integer level) {
        if (level == 0) {
            return ((SysOccupationalHazardsMapper)this.baseMapper).selectCount(null);
        }
        if (level == 2) {
            return 0L;
        }
        if (level == 1) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.lambda().eq(SysOccupationalHazards::getType, (Object)code);
            Long progenyNum = ((SysOccupationalHazardsMapper)this.baseMapper).selectCount((Wrapper)wrapper) - 1L;
            return progenyNum;
        }
        throw new ServiceException("\u5371\u5bb3\u56e0\u6570\u7b49\u7ea7\u9519\u8bef");
    }
}

