/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.sys.impl;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.modules.sys.dao.sys.SysIndustryMapper;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysIndustry;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysIndustryService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SysIndustryServiceImpl
extends ServiceImpl<SysIndustryMapper, SysIndustry>
implements ISysIndustryService {
    @Override
    public List<SysIndustry> query(SysIndustry industry, LayuiGridParam param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (industry.getPid() != null) {
            SysIndustry pData = (SysIndustry)this.getById(industry.getPid());
            if (pData.getLevel() == 0) {
                queryWrapper.eq((Object)"level", (Object)(pData.getLevel() + 1));
            } else if (pData.getLevel() == 1) {
                ((QueryWrapper)queryWrapper.eq((Object)"industry_code1", (Object)pData.getCode())).eq((Object)"level", (Object)(pData.getLevel() + 1));
            } else if (pData.getLevel() == 2) {
                ((QueryWrapper)queryWrapper.eq((Object)"industry_code2", (Object)pData.getCode())).eq((Object)"level", (Object)(pData.getLevel() + 1));
            } else if (pData.getLevel() == 3) {
                ((QueryWrapper)queryWrapper.eq((Object)"industry_code3", (Object)pData.getCode())).eq((Object)"level", (Object)(pData.getLevel() + 1));
            }
        }
        if (industry.getName() != null && !industry.getName().isEmpty()) {
            queryWrapper.like((Object)"name", (Object)("%" + industry.getName() + "%"));
            queryWrapper.eq((Object)"level", (Object)3);
        }
        if (industry.getIsShow() != null) {
            queryWrapper.eq((Object)"is_show", (Object)industry.getIsShow());
        }
        queryWrapper.orderByAsc((Object)"level", (Object[])new String[]{"id"});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Long getProgenyNum(String code, Integer level) {
        if (level == 0) {
            return ((SysIndustryMapper)this.baseMapper).selectCount(null);
        }
        Long progenyNum = ((SysIndustryMapper)this.baseMapper).getProgenyNum(code);
        if (progenyNum < 0L) {
            throw new ServiceException(code + "\u884c\u4e1a\u540e\u4ee3\u8282\u70b9\u6570\u91cf\u9519\u8bef");
        }
        return progenyNum;
    }

    @Override
    public String getNameByCode(String code) {
        if (code == null) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"code", (Object)code);
        SysIndustry industry = (SysIndustry)this.getOne((Wrapper)wrapper);
        if (industry == null) {
            return null;
        }
        return industry.getName();
    }
}

